/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeResourcePermissionsRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> PRINCIPALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("principalId").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").isBinary(false).build();
    private static final DescribeResourcePermissionsRequestModelMarshaller INSTANCE = new DescribeResourcePermissionsRequestModelMarshaller();

    private DescribeResourcePermissionsRequestModelMarshaller() {
    }

    public static DescribeResourcePermissionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeResourcePermissionsRequest describeResourcePermissionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeResourcePermissionsRequest), (String)"describeResourcePermissionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeResourcePermissionsRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeResourcePermissionsRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)describeResourcePermissionsRequest.principalId(), PRINCIPALID_BINDING);
            protocolMarshaller.marshall((Object)describeResourcePermissionsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)describeResourcePermissionsRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

