/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeDocumentVersionsRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHENTICATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Authentication").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("DocumentId").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<String> INCLUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("include").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("fields").isBinary(false).build();
    private static final DescribeDocumentVersionsRequestModelMarshaller INSTANCE = new DescribeDocumentVersionsRequestModelMarshaller();

    private DescribeDocumentVersionsRequestModelMarshaller() {
    }

    public static DescribeDocumentVersionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeDocumentVersionsRequest describeDocumentVersionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeDocumentVersionsRequest), (String)"describeDocumentVersionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeDocumentVersionsRequest.authenticationToken(), AUTHENTICATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeDocumentVersionsRequest.documentId(), DOCUMENTID_BINDING);
            protocolMarshaller.marshall((Object)describeDocumentVersionsRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)describeDocumentVersionsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)describeDocumentVersionsRequest.include(), INCLUDE_BINDING);
            protocolMarshaller.marshall((Object)describeDocumentVersionsRequest.fields(), FIELDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

