/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.workdocs.model.BooleanEnumType;
import software.amazon.awssdk.services.workdocs.model.LocaleType;
import software.amazon.awssdk.services.workdocs.model.StorageRuleType;
import software.amazon.awssdk.services.workdocs.model.UserType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private final String authenticationToken;
    private final String userId;
    private final String givenName;
    private final String surname;
    private final String type;
    private final StorageRuleType storageRule;
    private final String timeZoneId;
    private final String locale;
    private final String grantPoweruserPrivileges;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.userId = builder.userId;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.type = builder.type;
        this.storageRule = builder.storageRule;
        this.timeZoneId = builder.timeZoneId;
        this.locale = builder.locale;
        this.grantPoweruserPrivileges = builder.grantPoweruserPrivileges;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String userId() {
        return this.userId;
    }

    public String givenName() {
        return this.givenName;
    }

    public String surname() {
        return this.surname;
    }

    public UserType type() {
        return UserType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public StorageRuleType storageRule() {
        return this.storageRule;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public LocaleType locale() {
        return LocaleType.fromValue(this.locale);
    }

    public String localeAsString() {
        return this.locale;
    }

    public BooleanEnumType grantPoweruserPrivileges() {
        return BooleanEnumType.fromValue(this.grantPoweruserPrivileges);
    }

    public String grantPoweruserPrivilegesAsString() {
        return this.grantPoweruserPrivileges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantPoweruserPrivilegesAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.storageRule(), other.storageRule()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.grantPoweruserPrivilegesAsString(), other.grantPoweruserPrivilegesAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("UserId", (Object)this.userId()).add("GivenName", (Object)this.givenName()).add("Surname", (Object)this.surname()).add("Type", (Object)this.typeAsString()).add("StorageRule", (Object)this.storageRule()).add("TimeZoneId", (Object)this.timeZoneId()).add("Locale", (Object)this.localeAsString()).add("GrantPoweruserPrivileges", (Object)this.grantPoweruserPrivilegesAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "StorageRule": {
                return Optional.ofNullable(clazz.cast(this.storageRule()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "GrantPoweruserPrivileges": {
                return Optional.ofNullable(clazz.cast(this.grantPoweruserPrivilegesAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String userId;
        private String givenName;
        private String surname;
        private String type;
        private StorageRuleType storageRule;
        private String timeZoneId;
        private String locale;
        private String grantPoweruserPrivileges;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.userId(model.userId);
            this.givenName(model.givenName);
            this.surname(model.surname);
            this.type(model.type);
            this.storageRule(model.storageRule);
            this.timeZoneId(model.timeZoneId);
            this.locale(model.locale);
            this.grantPoweruserPrivileges(model.grantPoweruserPrivileges);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public final String getSurname() {
            return this.surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return this.storageRule != null ? this.storageRule.toBuilder() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleType locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getGrantPoweruserPrivileges() {
            return this.grantPoweruserPrivileges;
        }

        @Override
        public final Builder grantPoweruserPrivileges(String grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges = grantPoweruserPrivileges;
            return this;
        }

        @Override
        public final Builder grantPoweruserPrivileges(BooleanEnumType grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges(grantPoweruserPrivileges.toString());
            return this;
        }

        public final void setGrantPoweruserPrivileges(String grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges = grantPoweruserPrivileges;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder authenticationToken(String var1);

        public Builder userId(String var1);

        public Builder givenName(String var1);

        public Builder surname(String var1);

        public Builder type(String var1);

        public Builder type(UserType var1);

        public Builder storageRule(StorageRuleType var1);

        default public Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return this.storageRule((StorageRuleType)((StorageRuleType.Builder)StorageRuleType.builder().applyMutation(storageRule)).build());
        }

        public Builder timeZoneId(String var1);

        public Builder locale(String var1);

        public Builder locale(LocaleType var1);

        public Builder grantPoweruserPrivileges(String var1);

        public Builder grantPoweruserPrivileges(BooleanEnumType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

