/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GroupMetadataMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final GroupMetadataMarshaller INSTANCE = new GroupMetadataMarshaller();

    private GroupMetadataMarshaller() {
    }

    public static GroupMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GroupMetadata groupMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)groupMetadata, (String)"groupMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)groupMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)groupMetadata.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

