/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentVersionMetadataMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").isBinary(false).build();
    private static final MarshallingInfo<Long> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Signature").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> MODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModifiedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONTENTCREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentCreatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONTENTMODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentModifiedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> CREATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorId").isBinary(false).build();
    private static final MarshallingInfo<Map> THUMBNAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Thumbnail").isBinary(false).build();
    private static final MarshallingInfo<Map> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();
    private static final DocumentVersionMetadataMarshaller INSTANCE = new DocumentVersionMetadataMarshaller();

    private DocumentVersionMetadataMarshaller() {
    }

    public static DocumentVersionMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentVersionMetadata documentVersionMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentVersionMetadata, (String)"documentVersionMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentVersionMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.contentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.size(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.signature(), SIGNATURE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.modifiedTimestamp(), MODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.contentCreatedTimestamp(), CONTENTCREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.contentModifiedTimestamp(), CONTENTMODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.creatorId(), CREATORID_BINDING);
            protocolMarshaller.marshall(documentVersionMetadata.thumbnailAsStrings(), THUMBNAIL_BINDING);
            protocolMarshaller.marshall(documentVersionMetadata.sourceAsStrings(), SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

