/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.User;

public class DescribeUsersPublisher
implements SdkPublisher<DescribeUsersResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeUsersPublisher(WorkDocsAsyncClient client, DescribeUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeUsersPublisher(WorkDocsAsyncClient client, DescribeUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<User> users() {
        Function<DescribeUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeUsersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeUsersPublisher resume(DescribeUsersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeUsersPublisher(this.client, (DescribeUsersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeUsersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeUsersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeUsersResponseFetcher
    implements AsyncPageFetcher<DescribeUsersResponse> {
        private DescribeUsersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUsersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeUsersResponse> nextPage(DescribeUsersResponse previousPage) {
            if (previousPage == null) {
                return DescribeUsersPublisher.this.client.describeUsers(DescribeUsersPublisher.this.firstRequest);
            }
            return DescribeUsersPublisher.this.client.describeUsers((DescribeUsersRequest)((Object)DescribeUsersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

