/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDocumentPathRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, GetDocumentPathRequest> {
    private final String authenticationToken;
    private final String documentId;
    private final Integer limit;
    private final String fields;
    private final String marker;

    private GetDocumentPathRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.limit = builder.limit;
        this.fields = builder.fields;
        this.marker = builder.marker;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public Integer limit() {
        return this.limit;
    }

    public String fields() {
        return this.fields;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentPathRequest)) {
            return false;
        }
        GetDocumentPathRequest other = (GetDocumentPathRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"GetDocumentPathRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("DocumentId", (Object)this.documentId()).add("Limit", (Object)this.limit()).add("Fields", (Object)this.fields()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.of(clazz.cast(this.documentId()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Fields": {
                return Optional.of(clazz.cast(this.fields()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private Integer limit;
        private String fields;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentPathRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.limit(model.limit);
            this.fields(model.fields);
            this.marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentPathRequest build() {
            return new GetDocumentPathRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, GetDocumentPathRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder limit(Integer var1);

        public Builder fields(String var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

