/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRootFoldersResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeRootFoldersResponse> {
    private final List<FolderMetadata> folders;
    private final String marker;

    private DescribeRootFoldersResponse(BuilderImpl builder) {
        super(builder);
        this.folders = builder.folders;
        this.marker = builder.marker;
    }

    public List<FolderMetadata> folders() {
        return this.folders;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.folders());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRootFoldersResponse)) {
            return false;
        }
        DescribeRootFoldersResponse other = (DescribeRootFoldersResponse)((Object)obj);
        return Objects.equals(this.folders(), other.folders()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRootFoldersResponse").add("Folders", this.folders()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Folders": {
                return Optional.of(clazz.cast(this.folders()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<FolderMetadata> folders;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRootFoldersResponse model) {
            super(model);
            this.folders(model.folders);
            this.marker(model.marker);
        }

        public final Collection<FolderMetadata.Builder> getFolders() {
            return this.folders != null ? (Collection)this.folders.stream().map(FolderMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder folders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(FolderMetadata ... folders) {
            this.folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(Consumer<FolderMetadata.Builder> ... folders) {
            this.folders(Stream.of(folders).map(c -> (FolderMetadata)((FolderMetadata.Builder)FolderMetadata.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFolders(Collection<FolderMetadata.BuilderImpl> folders) {
            this.folders = FolderMetadataListCopier.copyFromBuilder(folders);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeRootFoldersResponse build() {
            return new DescribeRootFoldersResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeRootFoldersResponse> {
        public Builder folders(Collection<FolderMetadata> var1);

        public Builder folders(FolderMetadata ... var1);

        public Builder folders(Consumer<FolderMetadata.Builder> ... var1);

        public Builder marker(String var1);
    }
}

