/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.ResourcePath;

@SdkInternalApi
public class ResourcePathMarshaller {
    private static final MarshallingInfo<List> COMPONENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Components").build();
    private static final ResourcePathMarshaller instance = new ResourcePathMarshaller();

    public static ResourcePathMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourcePath resourcePath, ProtocolMarshaller protocolMarshaller) {
        if (resourcePath == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourcePath.components(), COMPONENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

