/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.services.workdocs.model.ShareStatusType;
import software.amazon.awssdk.services.workdocs.transform.ShareResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ShareResult
implements StructuredPojo,
ToCopyableBuilder<Builder, ShareResult> {
    private final String principalId;
    private final String role;
    private final String status;
    private final String shareId;
    private final String statusMessage;

    private ShareResult(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.role = builder.role;
        this.status = builder.status;
        this.shareId = builder.shareId;
        this.statusMessage = builder.statusMessage;
    }

    public String principalId() {
        return this.principalId;
    }

    public String role() {
        return this.role;
    }

    public String status() {
        return this.status;
    }

    public String shareId() {
        return this.shareId;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.principalId() == null ? 0 : this.principalId().hashCode());
        hashCode = 31 * hashCode + (this.role() == null ? 0 : this.role().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.shareId() == null ? 0 : this.shareId().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareResult)) {
            return false;
        }
        ShareResult other = (ShareResult)obj;
        if (other.principalId() == null ^ this.principalId() == null) {
            return false;
        }
        if (other.principalId() != null && !other.principalId().equals(this.principalId())) {
            return false;
        }
        if (other.role() == null ^ this.role() == null) {
            return false;
        }
        if (other.role() != null && !other.role().equals(this.role())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.shareId() == null ^ this.shareId() == null) {
            return false;
        }
        if (other.shareId() != null && !other.shareId().equals(this.shareId())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        return other.statusMessage() == null || other.statusMessage().equals(this.statusMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.principalId() != null) {
            sb.append("PrincipalId: ").append(this.principalId()).append(",");
        }
        if (this.role() != null) {
            sb.append("Role: ").append(this.role()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.shareId() != null) {
            sb.append("ShareId: ").append(this.shareId()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShareResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String principalId;
        private String role;
        private String status;
        private String shareId;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareResult model) {
            this.setPrincipalId(model.principalId);
            this.setRole(model.role);
            this.setStatus(model.status);
            this.setShareId(model.shareId);
            this.setStatusMessage(model.statusMessage);
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final void setRole(RoleType role) {
            this.role(role.toString());
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ShareStatusType status) {
            this.status(status.toString());
        }

        public final String getShareId() {
            return this.shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ShareResult build() {
            return new ShareResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShareResult> {
        public Builder principalId(String var1);

        public Builder role(String var1);

        public Builder role(RoleType var1);

        public Builder status(String var1);

        public Builder status(ShareStatusType var1);

        public Builder shareId(String var1);

        public Builder statusMessage(String var1);
    }
}

