/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.workdocs.model.LabelsCopier;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.services.workdocs.transform.FolderMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FolderMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, FolderMetadata> {
    private final String id;
    private final String name;
    private final String creatorId;
    private final String parentFolderId;
    private final Date createdTimestamp;
    private final Date modifiedTimestamp;
    private final String resourceState;
    private final String signature;
    private final List<String> labels;
    private final Long size;
    private final Long latestVersionSize;

    private FolderMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.resourceState = builder.resourceState;
        this.signature = builder.signature;
        this.labels = builder.labels;
        this.size = builder.size;
        this.latestVersionSize = builder.latestVersionSize;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public Date createdTimestamp() {
        return this.createdTimestamp;
    }

    public Date modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public String resourceState() {
        return this.resourceState;
    }

    public String signature() {
        return this.signature;
    }

    public List<String> labels() {
        return this.labels;
    }

    public Long size() {
        return this.size;
    }

    public Long latestVersionSize() {
        return this.latestVersionSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.creatorId() == null ? 0 : this.creatorId().hashCode());
        hashCode = 31 * hashCode + (this.parentFolderId() == null ? 0 : this.parentFolderId().hashCode());
        hashCode = 31 * hashCode + (this.createdTimestamp() == null ? 0 : this.createdTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.modifiedTimestamp() == null ? 0 : this.modifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.resourceState() == null ? 0 : this.resourceState().hashCode());
        hashCode = 31 * hashCode + (this.signature() == null ? 0 : this.signature().hashCode());
        hashCode = 31 * hashCode + (this.labels() == null ? 0 : this.labels().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        hashCode = 31 * hashCode + (this.latestVersionSize() == null ? 0 : this.latestVersionSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderMetadata)) {
            return false;
        }
        FolderMetadata other = (FolderMetadata)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.creatorId() == null ^ this.creatorId() == null) {
            return false;
        }
        if (other.creatorId() != null && !other.creatorId().equals(this.creatorId())) {
            return false;
        }
        if (other.parentFolderId() == null ^ this.parentFolderId() == null) {
            return false;
        }
        if (other.parentFolderId() != null && !other.parentFolderId().equals(this.parentFolderId())) {
            return false;
        }
        if (other.createdTimestamp() == null ^ this.createdTimestamp() == null) {
            return false;
        }
        if (other.createdTimestamp() != null && !other.createdTimestamp().equals(this.createdTimestamp())) {
            return false;
        }
        if (other.modifiedTimestamp() == null ^ this.modifiedTimestamp() == null) {
            return false;
        }
        if (other.modifiedTimestamp() != null && !other.modifiedTimestamp().equals(this.modifiedTimestamp())) {
            return false;
        }
        if (other.resourceState() == null ^ this.resourceState() == null) {
            return false;
        }
        if (other.resourceState() != null && !other.resourceState().equals(this.resourceState())) {
            return false;
        }
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        if (other.labels() == null ^ this.labels() == null) {
            return false;
        }
        if (other.labels() != null && !other.labels().equals(this.labels())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.latestVersionSize() == null ^ this.latestVersionSize() == null) {
            return false;
        }
        return other.latestVersionSize() == null || other.latestVersionSize().equals(this.latestVersionSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        if (this.parentFolderId() != null) {
            sb.append("ParentFolderId: ").append(this.parentFolderId()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.modifiedTimestamp() != null) {
            sb.append("ModifiedTimestamp: ").append(this.modifiedTimestamp()).append(",");
        }
        if (this.resourceState() != null) {
            sb.append("ResourceState: ").append(this.resourceState()).append(",");
        }
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.latestVersionSize() != null) {
            sb.append("LatestVersionSize: ").append(this.latestVersionSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FolderMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String creatorId;
        private String parentFolderId;
        private Date createdTimestamp;
        private Date modifiedTimestamp;
        private String resourceState;
        private String signature;
        private List<String> labels;
        private Long size;
        private Long latestVersionSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderMetadata model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setCreatorId(model.creatorId);
            this.setParentFolderId(model.parentFolderId);
            this.setCreatedTimestamp(model.createdTimestamp);
            this.setModifiedTimestamp(model.modifiedTimestamp);
            this.setResourceState(model.resourceState);
            this.setSignature(model.signature);
            this.setLabels(model.labels);
            this.setSize(model.size);
            this.setLatestVersionSize(model.latestVersionSize);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final Date getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Date createdTimestamp) {
            this.createdTimestamp = StandardMemberCopier.copy((Date)createdTimestamp);
            return this;
        }

        public final void setCreatedTimestamp(Date createdTimestamp) {
            this.createdTimestamp = StandardMemberCopier.copy((Date)createdTimestamp);
        }

        public final Date getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Date modifiedTimestamp) {
            this.modifiedTimestamp = StandardMemberCopier.copy((Date)modifiedTimestamp);
            return this;
        }

        public final void setModifiedTimestamp(Date modifiedTimestamp) {
            this.modifiedTimestamp = StandardMemberCopier.copy((Date)modifiedTimestamp);
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        public final void setResourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState.toString());
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>(labels.length);
            }
            for (String e : labels) {
                this.labels.add(e);
            }
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = LabelsCopier.copy(labels);
        }

        @SafeVarargs
        public final void setLabels(String ... labels) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>(labels.length);
            }
            for (String e : labels) {
                this.labels.add(e);
            }
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final Long getLatestVersionSize() {
            return this.latestVersionSize;
        }

        @Override
        public final Builder latestVersionSize(Long latestVersionSize) {
            this.latestVersionSize = latestVersionSize;
            return this;
        }

        public final void setLatestVersionSize(Long latestVersionSize) {
            this.latestVersionSize = latestVersionSize;
        }

        public FolderMetadata build() {
            return new FolderMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FolderMetadata> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder creatorId(String var1);

        public Builder parentFolderId(String var1);

        public Builder createdTimestamp(Date var1);

        public Builder modifiedTimestamp(Date var1);

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);

        public Builder signature(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder size(Long var1);

        public Builder latestVersionSize(Long var1);
    }
}

