/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentSourceUrlMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentStatusType;
import software.amazon.awssdk.services.workdocs.model.DocumentThumbnailUrlMapCopier;
import software.amazon.awssdk.services.workdocs.transform.DocumentVersionMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentVersionMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentVersionMetadata> {
    private final String id;
    private final String name;
    private final String contentType;
    private final Long size;
    private final String signature;
    private final String status;
    private final Date createdTimestamp;
    private final Date modifiedTimestamp;
    private final Date contentCreatedTimestamp;
    private final Date contentModifiedTimestamp;
    private final String creatorId;
    private final Map<String, String> thumbnail;
    private final Map<String, String> source;

    private DocumentVersionMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.contentType = builder.contentType;
        this.size = builder.size;
        this.signature = builder.signature;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.contentCreatedTimestamp = builder.contentCreatedTimestamp;
        this.contentModifiedTimestamp = builder.contentModifiedTimestamp;
        this.creatorId = builder.creatorId;
        this.thumbnail = builder.thumbnail;
        this.source = builder.source;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String contentType() {
        return this.contentType;
    }

    public Long size() {
        return this.size;
    }

    public String signature() {
        return this.signature;
    }

    public String status() {
        return this.status;
    }

    public Date createdTimestamp() {
        return this.createdTimestamp;
    }

    public Date modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public Date contentCreatedTimestamp() {
        return this.contentCreatedTimestamp;
    }

    public Date contentModifiedTimestamp() {
        return this.contentModifiedTimestamp;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public Map<String, String> thumbnail() {
        return this.thumbnail;
    }

    public Map<String, String> source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.contentType() == null ? 0 : this.contentType().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        hashCode = 31 * hashCode + (this.signature() == null ? 0 : this.signature().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.createdTimestamp() == null ? 0 : this.createdTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.modifiedTimestamp() == null ? 0 : this.modifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.contentCreatedTimestamp() == null ? 0 : this.contentCreatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.contentModifiedTimestamp() == null ? 0 : this.contentModifiedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.creatorId() == null ? 0 : this.creatorId().hashCode());
        hashCode = 31 * hashCode + (this.thumbnail() == null ? 0 : this.thumbnail().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionMetadata)) {
            return false;
        }
        DocumentVersionMetadata other = (DocumentVersionMetadata)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.createdTimestamp() == null ^ this.createdTimestamp() == null) {
            return false;
        }
        if (other.createdTimestamp() != null && !other.createdTimestamp().equals(this.createdTimestamp())) {
            return false;
        }
        if (other.modifiedTimestamp() == null ^ this.modifiedTimestamp() == null) {
            return false;
        }
        if (other.modifiedTimestamp() != null && !other.modifiedTimestamp().equals(this.modifiedTimestamp())) {
            return false;
        }
        if (other.contentCreatedTimestamp() == null ^ this.contentCreatedTimestamp() == null) {
            return false;
        }
        if (other.contentCreatedTimestamp() != null && !other.contentCreatedTimestamp().equals(this.contentCreatedTimestamp())) {
            return false;
        }
        if (other.contentModifiedTimestamp() == null ^ this.contentModifiedTimestamp() == null) {
            return false;
        }
        if (other.contentModifiedTimestamp() != null && !other.contentModifiedTimestamp().equals(this.contentModifiedTimestamp())) {
            return false;
        }
        if (other.creatorId() == null ^ this.creatorId() == null) {
            return false;
        }
        if (other.creatorId() != null && !other.creatorId().equals(this.creatorId())) {
            return false;
        }
        if (other.thumbnail() == null ^ this.thumbnail() == null) {
            return false;
        }
        if (other.thumbnail() != null && !other.thumbnail().equals(this.thumbnail())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        return other.source() == null || other.source().equals(this.source());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.createdTimestamp()).append(",");
        }
        if (this.modifiedTimestamp() != null) {
            sb.append("ModifiedTimestamp: ").append(this.modifiedTimestamp()).append(",");
        }
        if (this.contentCreatedTimestamp() != null) {
            sb.append("ContentCreatedTimestamp: ").append(this.contentCreatedTimestamp()).append(",");
        }
        if (this.contentModifiedTimestamp() != null) {
            sb.append("ContentModifiedTimestamp: ").append(this.contentModifiedTimestamp()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        if (this.thumbnail() != null) {
            sb.append("Thumbnail: ").append(this.thumbnail()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentVersionMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String contentType;
        private Long size;
        private String signature;
        private String status;
        private Date createdTimestamp;
        private Date modifiedTimestamp;
        private Date contentCreatedTimestamp;
        private Date contentModifiedTimestamp;
        private String creatorId;
        private Map<String, String> thumbnail;
        private Map<String, String> source;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionMetadata model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setContentType(model.contentType);
            this.setSize(model.size);
            this.setSignature(model.signature);
            this.setStatus(model.status);
            this.setCreatedTimestamp(model.createdTimestamp);
            this.setModifiedTimestamp(model.modifiedTimestamp);
            this.setContentCreatedTimestamp(model.contentCreatedTimestamp);
            this.setContentModifiedTimestamp(model.contentModifiedTimestamp);
            this.setCreatorId(model.creatorId);
            this.setThumbnail(model.thumbnail);
            this.setSource(model.source);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(DocumentStatusType status) {
            this.status(status.toString());
        }

        public final Date getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Date createdTimestamp) {
            this.createdTimestamp = StandardMemberCopier.copy((Date)createdTimestamp);
            return this;
        }

        public final void setCreatedTimestamp(Date createdTimestamp) {
            this.createdTimestamp = StandardMemberCopier.copy((Date)createdTimestamp);
        }

        public final Date getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Date modifiedTimestamp) {
            this.modifiedTimestamp = StandardMemberCopier.copy((Date)modifiedTimestamp);
            return this;
        }

        public final void setModifiedTimestamp(Date modifiedTimestamp) {
            this.modifiedTimestamp = StandardMemberCopier.copy((Date)modifiedTimestamp);
        }

        public final Date getContentCreatedTimestamp() {
            return this.contentCreatedTimestamp;
        }

        @Override
        public final Builder contentCreatedTimestamp(Date contentCreatedTimestamp) {
            this.contentCreatedTimestamp = StandardMemberCopier.copy((Date)contentCreatedTimestamp);
            return this;
        }

        public final void setContentCreatedTimestamp(Date contentCreatedTimestamp) {
            this.contentCreatedTimestamp = StandardMemberCopier.copy((Date)contentCreatedTimestamp);
        }

        public final Date getContentModifiedTimestamp() {
            return this.contentModifiedTimestamp;
        }

        @Override
        public final Builder contentModifiedTimestamp(Date contentModifiedTimestamp) {
            this.contentModifiedTimestamp = StandardMemberCopier.copy((Date)contentModifiedTimestamp);
            return this;
        }

        public final void setContentModifiedTimestamp(Date contentModifiedTimestamp) {
            this.contentModifiedTimestamp = StandardMemberCopier.copy((Date)contentModifiedTimestamp);
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final Map<String, String> getThumbnail() {
            return this.thumbnail;
        }

        @Override
        public final Builder thumbnail(Map<String, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copy(thumbnail);
            return this;
        }

        public final void setThumbnail(Map<String, String> thumbnail) {
            this.thumbnail = DocumentThumbnailUrlMapCopier.copy(thumbnail);
        }

        public final Map<String, String> getSource() {
            return this.source;
        }

        @Override
        public final Builder source(Map<String, String> source) {
            this.source = DocumentSourceUrlMapCopier.copy(source);
            return this;
        }

        public final void setSource(Map<String, String> source) {
            this.source = DocumentSourceUrlMapCopier.copy(source);
        }

        public DocumentVersionMetadata build() {
            return new DocumentVersionMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentVersionMetadata> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder contentType(String var1);

        public Builder size(Long var1);

        public Builder signature(String var1);

        public Builder status(String var1);

        public Builder status(DocumentStatusType var1);

        public Builder createdTimestamp(Date var1);

        public Builder modifiedTimestamp(Date var1);

        public Builder contentCreatedTimestamp(Date var1);

        public Builder contentModifiedTimestamp(Date var1);

        public Builder creatorId(String var1);

        public Builder thumbnail(Map<String, String> var1);

        public Builder source(Map<String, String> var1);
    }
}

