/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.RecommendationIdListCopier;
import software.amazon.awssdk.services.wisdom.model.RecommendationSourceType;
import software.amazon.awssdk.services.wisdom.model.RecommendationTriggerData;
import software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationTrigger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationTrigger> {
    private static final SdkField<RecommendationTriggerData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(RecommendationTrigger.getter(RecommendationTrigger::data)).setter(RecommendationTrigger.setter(Builder::data)).constructor(RecommendationTriggerData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(RecommendationTrigger.getter(RecommendationTrigger::id)).setter(RecommendationTrigger.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationIds").getter(RecommendationTrigger.getter(RecommendationTrigger::recommendationIds)).setter(RecommendationTrigger.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(RecommendationTrigger.getter(RecommendationTrigger::sourceAsString)).setter(RecommendationTrigger.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RecommendationTrigger.getter(RecommendationTrigger::typeAsString)).setter(RecommendationTrigger.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, ID_FIELD, RECOMMENDATION_IDS_FIELD, SOURCE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendationTrigger.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RecommendationTriggerData data;
    private final String id;
    private final List<String> recommendationIds;
    private final String source;
    private final String type;

    private RecommendationTrigger(BuilderImpl builder) {
        this.data = builder.data;
        this.id = builder.id;
        this.recommendationIds = builder.recommendationIds;
        this.source = builder.source;
        this.type = builder.type;
    }

    public final RecommendationTriggerData data() {
        return this.data;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public final RecommendationSourceType source() {
        return RecommendationSourceType.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final RecommendationTriggerType type() {
        return RecommendationTriggerType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationTrigger)) {
            return false;
        }
        RecommendationTrigger other = (RecommendationTrigger)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.id(), other.id()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationTrigger").add("Data", (Object)this.data()).add("Id", (Object)this.id()).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).add("Source", (Object)this.sourceAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "recommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", DATA_FIELD);
        map.put("id", ID_FIELD);
        map.put("recommendationIds", RECOMMENDATION_IDS_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationTrigger, T> g) {
        return obj -> g.apply((RecommendationTrigger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecommendationTriggerData data;
        private String id;
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();
        private String source;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationTrigger model) {
            this.data(model.data);
            this.id(model.id);
            this.recommendationIds(model.recommendationIds);
            this.source(model.source);
            this.type(model.type);
        }

        public final RecommendationTriggerData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(RecommendationTriggerData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(RecommendationTriggerData data) {
            this.data = data;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSourceType source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationTriggerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RecommendationTrigger build() {
            return new RecommendationTrigger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationTrigger> {
        public Builder data(RecommendationTriggerData var1);

        default public Builder data(Consumer<RecommendationTriggerData.Builder> data) {
            return this.data((RecommendationTriggerData)((RecommendationTriggerData.Builder)RecommendationTriggerData.builder().applyMutation(data)).build());
        }

        public Builder id(String var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);

        public Builder source(String var1);

        public Builder source(RecommendationSourceType var1);

        public Builder type(String var1);

        public Builder type(RecommendationTriggerType var1);
    }
}

