/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.ContentMetadataCopier;
import software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration;
import software.amazon.awssdk.services.wisdom.model.ImportJobStatus;
import software.amazon.awssdk.services.wisdom.model.ImportJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportJobData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportJobData> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(ImportJobData.getter(ImportJobData::createdTime)).setter(ImportJobData.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<ExternalSourceConfiguration> EXTERNAL_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalSourceConfiguration").getter(ImportJobData.getter(ImportJobData::externalSourceConfiguration)).setter(ImportJobData.setter(Builder::externalSourceConfiguration)).constructor(ExternalSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourceConfiguration").build()}).build();
    private static final SdkField<String> FAILED_RECORD_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failedRecordReport").getter(ImportJobData.getter(ImportJobData::failedRecordReport)).setter(ImportJobData.setter(Builder::failedRecordReport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRecordReport").build()}).build();
    private static final SdkField<String> IMPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importJobId").getter(ImportJobData.getter(ImportJobData::importJobId)).setter(ImportJobData.setter(Builder::importJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobId").build()}).build();
    private static final SdkField<String> IMPORT_JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importJobType").getter(ImportJobData.getter(ImportJobData::importJobTypeAsString)).setter(ImportJobData.setter(Builder::importJobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobType").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(ImportJobData.getter(ImportJobData::knowledgeBaseArn)).setter(ImportJobData.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(ImportJobData.getter(ImportJobData::knowledgeBaseId)).setter(ImportJobData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(ImportJobData.getter(ImportJobData::lastModifiedTime)).setter(ImportJobData.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(ImportJobData.getter(ImportJobData::metadata)).setter(ImportJobData.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImportJobData.getter(ImportJobData::statusAsString)).setter(ImportJobData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(ImportJobData.getter(ImportJobData::uploadId)).setter(ImportJobData.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(ImportJobData.getter(ImportJobData::url)).setter(ImportJobData.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("urlExpiry").getter(ImportJobData.getter(ImportJobData::urlExpiry)).setter(ImportJobData.setter(Builder::urlExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, EXTERNAL_SOURCE_CONFIGURATION_FIELD, FAILED_RECORD_REPORT_FIELD, IMPORT_JOB_ID_FIELD, IMPORT_JOB_TYPE_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, LAST_MODIFIED_TIME_FIELD, METADATA_FIELD, STATUS_FIELD, UPLOAD_ID_FIELD, URL_FIELD, URL_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportJobData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdTime;
    private final ExternalSourceConfiguration externalSourceConfiguration;
    private final String failedRecordReport;
    private final String importJobId;
    private final String importJobType;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final Instant lastModifiedTime;
    private final Map<String, String> metadata;
    private final String status;
    private final String uploadId;
    private final String url;
    private final Instant urlExpiry;

    private ImportJobData(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.externalSourceConfiguration = builder.externalSourceConfiguration;
        this.failedRecordReport = builder.failedRecordReport;
        this.importJobId = builder.importJobId;
        this.importJobType = builder.importJobType;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.uploadId = builder.uploadId;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final ExternalSourceConfiguration externalSourceConfiguration() {
        return this.externalSourceConfiguration;
    }

    public final String failedRecordReport() {
        return this.failedRecordReport;
    }

    public final String importJobId() {
        return this.importJobId;
    }

    public final ImportJobType importJobType() {
        return ImportJobType.fromValue(this.importJobType);
    }

    public final String importJobTypeAsString() {
        return this.importJobType;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final ImportJobStatus status() {
        return ImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final String url() {
        return this.url;
    }

    public final Instant urlExpiry() {
        return this.urlExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRecordReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobData)) {
            return false;
        }
        ImportJobData other = (ImportJobData)obj;
        return Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.externalSourceConfiguration(), other.externalSourceConfiguration()) && Objects.equals(this.failedRecordReport(), other.failedRecordReport()) && Objects.equals(this.importJobId(), other.importJobId()) && Objects.equals(this.importJobTypeAsString(), other.importJobTypeAsString()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.urlExpiry(), other.urlExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"ImportJobData").add("CreatedTime", (Object)this.createdTime()).add("ExternalSourceConfiguration", (Object)this.externalSourceConfiguration()).add("FailedRecordReport", (Object)(this.failedRecordReport() == null ? null : "*** Sensitive Data Redacted ***")).add("ImportJobId", (Object)this.importJobId()).add("ImportJobType", (Object)this.importJobTypeAsString()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Status", (Object)this.statusAsString()).add("UploadId", (Object)this.uploadId()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("UrlExpiry", (Object)this.urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "externalSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.externalSourceConfiguration()));
            }
            case "failedRecordReport": {
                return Optional.ofNullable(clazz.cast(this.failedRecordReport()));
            }
            case "importJobId": {
                return Optional.ofNullable(clazz.cast(this.importJobId()));
            }
            case "importJobType": {
                return Optional.ofNullable(clazz.cast(this.importJobTypeAsString()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "urlExpiry": {
                return Optional.ofNullable(clazz.cast(this.urlExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("externalSourceConfiguration", EXTERNAL_SOURCE_CONFIGURATION_FIELD);
        map.put("failedRecordReport", FAILED_RECORD_REPORT_FIELD);
        map.put("importJobId", IMPORT_JOB_ID_FIELD);
        map.put("importJobType", IMPORT_JOB_TYPE_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("url", URL_FIELD);
        map.put("urlExpiry", URL_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportJobData, T> g) {
        return obj -> g.apply((ImportJobData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdTime;
        private ExternalSourceConfiguration externalSourceConfiguration;
        private String failedRecordReport;
        private String importJobId;
        private String importJobType;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private Instant lastModifiedTime;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String uploadId;
        private String url;
        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobData model) {
            this.createdTime(model.createdTime);
            this.externalSourceConfiguration(model.externalSourceConfiguration);
            this.failedRecordReport(model.failedRecordReport);
            this.importJobId(model.importJobId);
            this.importJobType(model.importJobType);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.lastModifiedTime(model.lastModifiedTime);
            this.metadata(model.metadata);
            this.status(model.status);
            this.uploadId(model.uploadId);
            this.url(model.url);
            this.urlExpiry(model.urlExpiry);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final ExternalSourceConfiguration.Builder getExternalSourceConfiguration() {
            return this.externalSourceConfiguration != null ? this.externalSourceConfiguration.toBuilder() : null;
        }

        public final void setExternalSourceConfiguration(ExternalSourceConfiguration.BuilderImpl externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration != null ? externalSourceConfiguration.build() : null;
        }

        @Override
        public final Builder externalSourceConfiguration(ExternalSourceConfiguration externalSourceConfiguration) {
            this.externalSourceConfiguration = externalSourceConfiguration;
            return this;
        }

        public final String getFailedRecordReport() {
            return this.failedRecordReport;
        }

        public final void setFailedRecordReport(String failedRecordReport) {
            this.failedRecordReport = failedRecordReport;
        }

        @Override
        public final Builder failedRecordReport(String failedRecordReport) {
            this.failedRecordReport = failedRecordReport;
            return this;
        }

        public final String getImportJobId() {
            return this.importJobId;
        }

        public final void setImportJobId(String importJobId) {
            this.importJobId = importJobId;
        }

        @Override
        public final Builder importJobId(String importJobId) {
            this.importJobId = importJobId;
            return this;
        }

        public final String getImportJobType() {
            return this.importJobType;
        }

        public final void setImportJobType(String importJobType) {
            this.importJobType = importJobType;
        }

        @Override
        public final Builder importJobType(String importJobType) {
            this.importJobType = importJobType;
            return this;
        }

        @Override
        public final Builder importJobType(ImportJobType importJobType) {
            this.importJobType(importJobType == null ? null : importJobType.toString());
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return this.urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        public ImportJobData build() {
            return new ImportJobData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportJobData> {
        public Builder createdTime(Instant var1);

        public Builder externalSourceConfiguration(ExternalSourceConfiguration var1);

        default public Builder externalSourceConfiguration(Consumer<ExternalSourceConfiguration.Builder> externalSourceConfiguration) {
            return this.externalSourceConfiguration((ExternalSourceConfiguration)((ExternalSourceConfiguration.Builder)ExternalSourceConfiguration.builder().applyMutation(externalSourceConfiguration)).build());
        }

        public Builder failedRecordReport(String var1);

        public Builder importJobId(String var1);

        public Builder importJobType(String var1);

        public Builder importJobType(ImportJobType var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder metadata(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(ImportJobStatus var1);

        public Builder uploadId(String var1);

        public Builder url(String var1);

        public Builder urlExpiry(Instant var1);
    }
}

