/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.AssistantAssociationOutputData;
import software.amazon.awssdk.services.wisdom.model.AssociationType;
import software.amazon.awssdk.services.wisdom.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssistantAssociationData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssistantAssociationData> {
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(AssistantAssociationData.getter(AssistantAssociationData::assistantArn)).setter(AssistantAssociationData.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final SdkField<String> ASSISTANT_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantAssociationArn").getter(AssistantAssociationData.getter(AssistantAssociationData::assistantAssociationArn)).setter(AssistantAssociationData.setter(Builder::assistantAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationArn").build()}).build();
    private static final SdkField<String> ASSISTANT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantAssociationId").getter(AssistantAssociationData.getter(AssistantAssociationData::assistantAssociationId)).setter(AssistantAssociationData.setter(Builder::assistantAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationId").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(AssistantAssociationData.getter(AssistantAssociationData::assistantId)).setter(AssistantAssociationData.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<AssistantAssociationOutputData> ASSOCIATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("associationData").getter(AssistantAssociationData.getter(AssistantAssociationData::associationData)).setter(AssistantAssociationData.setter(Builder::associationData)).constructor(AssistantAssociationOutputData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationData").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationType").getter(AssistantAssociationData.getter(AssistantAssociationData::associationTypeAsString)).setter(AssistantAssociationData.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AssistantAssociationData.getter(AssistantAssociationData::tags)).setter(AssistantAssociationData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ARN_FIELD, ASSISTANT_ASSOCIATION_ARN_FIELD, ASSISTANT_ASSOCIATION_ID_FIELD, ASSISTANT_ID_FIELD, ASSOCIATION_DATA_FIELD, ASSOCIATION_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assistantArn", ASSISTANT_ARN_FIELD);
            this.put("assistantAssociationArn", ASSISTANT_ASSOCIATION_ARN_FIELD);
            this.put("assistantAssociationId", ASSISTANT_ASSOCIATION_ID_FIELD);
            this.put("assistantId", ASSISTANT_ID_FIELD);
            this.put("associationData", ASSOCIATION_DATA_FIELD);
            this.put("associationType", ASSOCIATION_TYPE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String assistantArn;
    private final String assistantAssociationArn;
    private final String assistantAssociationId;
    private final String assistantId;
    private final AssistantAssociationOutputData associationData;
    private final String associationType;
    private final Map<String, String> tags;

    private AssistantAssociationData(BuilderImpl builder) {
        this.assistantArn = builder.assistantArn;
        this.assistantAssociationArn = builder.assistantAssociationArn;
        this.assistantAssociationId = builder.assistantAssociationId;
        this.assistantId = builder.assistantId;
        this.associationData = builder.associationData;
        this.associationType = builder.associationType;
        this.tags = builder.tags;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public final String assistantAssociationArn() {
        return this.assistantAssociationArn;
    }

    public final String assistantAssociationId() {
        return this.assistantAssociationId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final AssistantAssociationOutputData associationData() {
        return this.associationData;
    }

    public final AssociationType associationType() {
        return AssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantAssociationData)) {
            return false;
        }
        AssistantAssociationData other = (AssistantAssociationData)obj;
        return Objects.equals(this.assistantArn(), other.assistantArn()) && Objects.equals(this.assistantAssociationArn(), other.assistantAssociationArn()) && Objects.equals(this.assistantAssociationId(), other.assistantAssociationId()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.associationData(), other.associationData()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AssistantAssociationData").add("AssistantArn", (Object)this.assistantArn()).add("AssistantAssociationArn", (Object)this.assistantAssociationArn()).add("AssistantAssociationId", (Object)this.assistantAssociationId()).add("AssistantId", (Object)this.assistantId()).add("AssociationData", (Object)this.associationData()).add("AssociationType", (Object)this.associationTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
            case "assistantAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.assistantAssociationArn()));
            }
            case "assistantAssociationId": {
                return Optional.ofNullable(clazz.cast(this.assistantAssociationId()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "associationData": {
                return Optional.ofNullable(clazz.cast(this.associationData()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssistantAssociationData, T> g) {
        return obj -> g.apply((AssistantAssociationData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assistantArn;
        private String assistantAssociationArn;
        private String assistantAssociationId;
        private String assistantId;
        private AssistantAssociationOutputData associationData;
        private String associationType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantAssociationData model) {
            this.assistantArn(model.assistantArn);
            this.assistantAssociationArn(model.assistantAssociationArn);
            this.assistantAssociationId(model.assistantAssociationId);
            this.assistantId(model.assistantId);
            this.associationData(model.associationData);
            this.associationType(model.associationType);
            this.tags(model.tags);
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantAssociationArn() {
            return this.assistantAssociationArn;
        }

        public final void setAssistantAssociationArn(String assistantAssociationArn) {
            this.assistantAssociationArn = assistantAssociationArn;
        }

        @Override
        public final Builder assistantAssociationArn(String assistantAssociationArn) {
            this.assistantAssociationArn = assistantAssociationArn;
            return this;
        }

        public final String getAssistantAssociationId() {
            return this.assistantAssociationId;
        }

        public final void setAssistantAssociationId(String assistantAssociationId) {
            this.assistantAssociationId = assistantAssociationId;
        }

        @Override
        public final Builder assistantAssociationId(String assistantAssociationId) {
            this.assistantAssociationId = assistantAssociationId;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final AssistantAssociationOutputData.Builder getAssociationData() {
            return this.associationData != null ? this.associationData.toBuilder() : null;
        }

        public final void setAssociationData(AssistantAssociationOutputData.BuilderImpl associationData) {
            this.associationData = associationData != null ? associationData.build() : null;
        }

        @Override
        public final Builder associationData(AssistantAssociationOutputData associationData) {
            this.associationData = associationData;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public AssistantAssociationData build() {
            return new AssistantAssociationData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssistantAssociationData> {
        public Builder assistantArn(String var1);

        public Builder assistantAssociationArn(String var1);

        public Builder assistantAssociationId(String var1);

        public Builder assistantId(String var1);

        public Builder associationData(AssistantAssociationOutputData var1);

        default public Builder associationData(Consumer<AssistantAssociationOutputData.Builder> associationData) {
            return this.associationData((AssistantAssociationOutputData)((AssistantAssociationOutputData.Builder)AssistantAssociationOutputData.builder().applyMutation(associationData)).build());
        }

        public Builder associationType(String var1);

        public Builder associationType(AssociationType var1);

        public Builder tags(Map<String, String> var1);
    }
}

