/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.ContentMetadataCopier;
import software.amazon.awssdk.services.wisdom.model.TagsCopier;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContentRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, CreateContentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateContentRequest.getter(CreateContentRequest::clientToken)).setter(CreateContentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(CreateContentRequest.getter(CreateContentRequest::knowledgeBaseId)).setter(CreateContentRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(CreateContentRequest.getter(CreateContentRequest::metadata)).setter(CreateContentRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateContentRequest.getter(CreateContentRequest::name)).setter(CreateContentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OVERRIDE_LINK_OUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideLinkOutUri").getter(CreateContentRequest.getter(CreateContentRequest::overrideLinkOutUri)).setter(CreateContentRequest.setter(Builder::overrideLinkOutUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLinkOutUri").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateContentRequest.getter(CreateContentRequest::tags)).setter(CreateContentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreateContentRequest.getter(CreateContentRequest::title)).setter(CreateContentRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(CreateContentRequest.getter(CreateContentRequest::uploadId)).setter(CreateContentRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, KNOWLEDGE_BASE_ID_FIELD, METADATA_FIELD, NAME_FIELD, OVERRIDE_LINK_OUT_URI_FIELD, TAGS_FIELD, TITLE_FIELD, UPLOAD_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("name", NAME_FIELD);
            this.put("overrideLinkOutUri", OVERRIDE_LINK_OUT_URI_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("uploadId", UPLOAD_ID_FIELD);
        }
    });
    private final String clientToken;
    private final String knowledgeBaseId;
    private final Map<String, String> metadata;
    private final String name;
    private final String overrideLinkOutUri;
    private final Map<String, String> tags;
    private final String title;
    private final String uploadId;

    private CreateContentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.overrideLinkOutUri = builder.overrideLinkOutUri;
        this.tags = builder.tags;
        this.title = builder.title;
        this.uploadId = builder.uploadId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String name() {
        return this.name;
    }

    public final String overrideLinkOutUri() {
        return this.overrideLinkOutUri;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String title() {
        return this.title;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideLinkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContentRequest)) {
            return false;
        }
        CreateContentRequest other = (CreateContentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.overrideLinkOutUri(), other.overrideLinkOutUri()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.uploadId(), other.uploadId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContentRequest").add("ClientToken", (Object)this.clientToken()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Name", (Object)this.name()).add("OverrideLinkOutUri", (Object)this.overrideLinkOutUri()).add("Tags", this.hasTags() ? this.tags() : null).add("Title", (Object)this.title()).add("UploadId", (Object)this.uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "overrideLinkOutUri": {
                return Optional.ofNullable(clazz.cast(this.overrideLinkOutUri()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateContentRequest, T> g) {
        return obj -> g.apply((CreateContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String knowledgeBaseId;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private String overrideLinkOutUri;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String title;
        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.metadata(model.metadata);
            this.name(model.name);
            this.overrideLinkOutUri(model.overrideLinkOutUri);
            this.tags(model.tags);
            this.title(model.title);
            this.uploadId(model.uploadId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOverrideLinkOutUri() {
            return this.overrideLinkOutUri;
        }

        public final void setOverrideLinkOutUri(String overrideLinkOutUri) {
            this.overrideLinkOutUri = overrideLinkOutUri;
        }

        @Override
        public final Builder overrideLinkOutUri(String overrideLinkOutUri) {
            this.overrideLinkOutUri = overrideLinkOutUri;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContentRequest build() {
            return new CreateContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContentRequest> {
        public Builder clientToken(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder name(String var1);

        public Builder overrideLinkOutUri(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder title(String var1);

        public Builder uploadId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

