/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.wisdom.DefaultWisdomBaseClientBuilder;
import software.amazon.awssdk.services.wisdom.DefaultWisdomClient;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.WisdomClientBuilder;
import software.amazon.awssdk.services.wisdom.WisdomServiceClientConfiguration;
import software.amazon.awssdk.services.wisdom.endpoints.WisdomEndpointProvider;

@SdkInternalApi
final class DefaultWisdomClientBuilder
extends DefaultWisdomBaseClientBuilder<WisdomClientBuilder, WisdomClient>
implements WisdomClientBuilder {
    DefaultWisdomClientBuilder() {
    }

    @Override
    public DefaultWisdomClientBuilder endpointProvider(WisdomEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WisdomClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWisdomClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WisdomServiceClientConfiguration serviceClientConfiguration = WisdomServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWisdomClient(serviceClientConfiguration, clientConfiguration);
    }
}

