/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wisdom.model.Document;
import software.amazon.awssdk.services.wisdom.model.RelevanceLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationData> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(RecommendationData.getter(RecommendationData::document)).setter(RecommendationData.setter(Builder::document)).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(RecommendationData.getter(RecommendationData::recommendationId)).setter(RecommendationData.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<String> RELEVANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relevanceLevel").getter(RecommendationData.getter(RecommendationData::relevanceLevelAsString)).setter(RecommendationData.setter(Builder::relevanceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceLevel").build()}).build();
    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("relevanceScore").getter(RecommendationData.getter(RecommendationData::relevanceScore)).setter(RecommendationData.setter(Builder::relevanceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, RECOMMENDATION_ID_FIELD, RELEVANCE_LEVEL_FIELD, RELEVANCE_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Document document;
    private final String recommendationId;
    private final String relevanceLevel;
    private final Double relevanceScore;

    private RecommendationData(BuilderImpl builder) {
        this.document = builder.document;
        this.recommendationId = builder.recommendationId;
        this.relevanceLevel = builder.relevanceLevel;
        this.relevanceScore = builder.relevanceScore;
    }

    public final Document document() {
        return this.document;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final RelevanceLevel relevanceLevel() {
        return RelevanceLevel.fromValue(this.relevanceLevel);
    }

    public final String relevanceLevelAsString() {
        return this.relevanceLevel;
    }

    public final Double relevanceScore() {
        return this.relevanceScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationData)) {
            return false;
        }
        RecommendationData other = (RecommendationData)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.relevanceLevelAsString(), other.relevanceLevelAsString()) && Objects.equals(this.relevanceScore(), other.relevanceScore());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationData").add("Document", (Object)this.document()).add("RecommendationId", (Object)this.recommendationId()).add("RelevanceLevel", (Object)this.relevanceLevelAsString()).add("RelevanceScore", (Object)this.relevanceScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "relevanceLevel": {
                return Optional.ofNullable(clazz.cast(this.relevanceLevelAsString()));
            }
            case "relevanceScore": {
                return Optional.ofNullable(clazz.cast(this.relevanceScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationData, T> g) {
        return obj -> g.apply((RecommendationData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Document document;
        private String recommendationId;
        private String relevanceLevel;
        private Double relevanceScore;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationData model) {
            this.document(model.document);
            this.recommendationId(model.recommendationId);
            this.relevanceLevel(model.relevanceLevel);
            this.relevanceScore(model.relevanceScore);
        }

        public final Document.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getRelevanceLevel() {
            return this.relevanceLevel;
        }

        public final void setRelevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
        }

        @Override
        public final Builder relevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
            return this;
        }

        @Override
        public final Builder relevanceLevel(RelevanceLevel relevanceLevel) {
            this.relevanceLevel(relevanceLevel == null ? null : relevanceLevel.toString());
            return this;
        }

        public final Double getRelevanceScore() {
            return this.relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public RecommendationData build() {
            return new RecommendationData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationData> {
        public Builder document(Document var1);

        default public Builder document(Consumer<Document.Builder> document) {
            return this.document((Document)((Document.Builder)Document.builder().applyMutation(document)).build());
        }

        public Builder recommendationId(String var1);

        public Builder relevanceLevel(String var1);

        public Builder relevanceLevel(RelevanceLevel var1);

        public Builder relevanceScore(Double var1);
    }
}

