/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrAsyncClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersRequest;
import software.amazon.awssdk.services.wickr.model.ListSecurityGroupUsersResponse;
import software.amazon.awssdk.services.wickr.model.User;

public class ListSecurityGroupUsersPublisher
implements SdkPublisher<ListSecurityGroupUsersResponse> {
    private final WickrAsyncClient client;
    private final ListSecurityGroupUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityGroupUsersPublisher(WickrAsyncClient client, ListSecurityGroupUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityGroupUsersPublisher(WickrAsyncClient client, ListSecurityGroupUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityGroupUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityGroupUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<User> users() {
        Function<ListSecurityGroupUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityGroupUsersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityGroupUsersResponseFetcher
    implements AsyncPageFetcher<ListSecurityGroupUsersResponse> {
        private ListSecurityGroupUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityGroupUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityGroupUsersResponse> nextPage(ListSecurityGroupUsersResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityGroupUsersPublisher.this.client.listSecurityGroupUsers(ListSecurityGroupUsersPublisher.this.firstRequest);
            }
            return ListSecurityGroupUsersPublisher.this.client.listSecurityGroupUsers((ListSecurityGroupUsersRequest)((Object)ListSecurityGroupUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

