/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.BatchUserErrorResponseItem;
import software.amazon.awssdk.services.wickr.model.BatchUserErrorResponseItemsCopier;
import software.amazon.awssdk.services.wickr.model.User;
import software.amazon.awssdk.services.wickr.model.UsersCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateUserResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, BatchCreateUserResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(BatchCreateUserResponse.getter(BatchCreateUserResponse::message)).setter(BatchCreateUserResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<User>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successful").getter(BatchCreateUserResponse.getter(BatchCreateUserResponse::successful)).setter(BatchCreateUserResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUserErrorResponseItem>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failed").getter(BatchCreateUserResponse.getter(BatchCreateUserResponse::failed)).setter(BatchCreateUserResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUserErrorResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateUserResponse.memberNameToFieldInitializer();
    private final String message;
    private final List<User> successful;
    private final List<BatchUserErrorResponseItem> failed;

    private BatchCreateUserResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<User> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchUserErrorResponseItem> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateUserResponse)) {
            return false;
        }
        BatchCreateUserResponse other = (BatchCreateUserResponse)((Object)obj);
        return Objects.equals(this.message(), other.message()) && this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateUserResponse").add("Message", (Object)this.message()).add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", MESSAGE_FIELD);
        map.put("successful", SUCCESSFUL_FIELD);
        map.put("failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateUserResponse, T> g) {
        return obj -> g.apply((BatchCreateUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String message;
        private List<User> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUserErrorResponseItem> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateUserResponse model) {
            super(model);
            this.message(model.message);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<User.Builder> getSuccessful() {
            List<User.Builder> result = UsersCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<User.BuilderImpl> successful) {
            this.successful = UsersCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<User> successful) {
            this.successful = UsersCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(User ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<User.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (User)((User.Builder)User.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUserErrorResponseItem.Builder> getFailed() {
            List<BatchUserErrorResponseItem.Builder> result = BatchUserErrorResponseItemsCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchUserErrorResponseItem.BuilderImpl> failed) {
            this.failed = BatchUserErrorResponseItemsCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchUserErrorResponseItem> failed) {
            this.failed = BatchUserErrorResponseItemsCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchUserErrorResponseItem ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchUserErrorResponseItem.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchUserErrorResponseItem)((BatchUserErrorResponseItem.Builder)BatchUserErrorResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateUserResponse build() {
            return new BatchCreateUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateUserResponse> {
        public Builder message(String var1);

        public Builder successful(Collection<User> var1);

        public Builder successful(User ... var1);

        public Builder successful(Consumer<User.Builder> ... var1);

        public Builder failed(Collection<BatchUserErrorResponseItem> var1);

        public Builder failed(BatchUserErrorResponseItem ... var1);

        public Builder failed(Consumer<BatchUserErrorResponseItem.Builder> ... var1);
    }
}

