/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.SecurityGroupSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroup> {
    private static final SdkField<Integer> ACTIVE_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("activeMembers").getter(SecurityGroup.getter(SecurityGroup::activeMembers)).setter(SecurityGroup.setter(Builder::activeMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeMembers").build()}).build();
    private static final SdkField<Integer> BOT_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("botMembers").getter(SecurityGroup.getter(SecurityGroup::botMembers)).setter(SecurityGroup.setter(Builder::botMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMembers").build()}).build();
    private static final SdkField<String> ACTIVE_DIRECTORY_GUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeDirectoryGuid").getter(SecurityGroup.getter(SecurityGroup::activeDirectoryGuid)).setter(SecurityGroup.setter(Builder::activeDirectoryGuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectoryGuid").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SecurityGroup.getter(SecurityGroup::id)).setter(SecurityGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDefault").getter(SecurityGroup.getter(SecurityGroup::isDefault)).setter(SecurityGroup.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefault").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SecurityGroup.getter(SecurityGroup::name)).setter(SecurityGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("modified").getter(SecurityGroup.getter(SecurityGroup::modified)).setter(SecurityGroup.setter(Builder::modified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modified").build()}).build();
    private static final SdkField<SecurityGroupSettings> SECURITY_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("securityGroupSettings").getter(SecurityGroup.getter(SecurityGroup::securityGroupSettings)).setter(SecurityGroup.setter(Builder::securityGroupSettings)).constructor(SecurityGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_MEMBERS_FIELD, BOT_MEMBERS_FIELD, ACTIVE_DIRECTORY_GUID_FIELD, ID_FIELD, IS_DEFAULT_FIELD, NAME_FIELD, MODIFIED_FIELD, SECURITY_GROUP_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer activeMembers;
    private final Integer botMembers;
    private final String activeDirectoryGuid;
    private final String id;
    private final Boolean isDefault;
    private final String name;
    private final Integer modified;
    private final SecurityGroupSettings securityGroupSettings;

    private SecurityGroup(BuilderImpl builder) {
        this.activeMembers = builder.activeMembers;
        this.botMembers = builder.botMembers;
        this.activeDirectoryGuid = builder.activeDirectoryGuid;
        this.id = builder.id;
        this.isDefault = builder.isDefault;
        this.name = builder.name;
        this.modified = builder.modified;
        this.securityGroupSettings = builder.securityGroupSettings;
    }

    public final Integer activeMembers() {
        return this.activeMembers;
    }

    public final Integer botMembers() {
        return this.botMembers;
    }

    public final String activeDirectoryGuid() {
        return this.activeDirectoryGuid;
    }

    public final String id() {
        return this.id;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String name() {
        return this.name;
    }

    public final Integer modified() {
        return this.modified;
    }

    public final SecurityGroupSettings securityGroupSettings() {
        return this.securityGroupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.botMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryGuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.modified());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        return Objects.equals(this.activeMembers(), other.activeMembers()) && Objects.equals(this.botMembers(), other.botMembers()) && Objects.equals(this.activeDirectoryGuid(), other.activeDirectoryGuid()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.modified(), other.modified()) && Objects.equals(this.securityGroupSettings(), other.securityGroupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroup").add("ActiveMembers", (Object)this.activeMembers()).add("BotMembers", (Object)this.botMembers()).add("ActiveDirectoryGuid", (Object)this.activeDirectoryGuid()).add("Id", (Object)this.id()).add("IsDefault", (Object)this.isDefault()).add("Name", (Object)this.name()).add("Modified", (Object)this.modified()).add("SecurityGroupSettings", (Object)this.securityGroupSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeMembers": {
                return Optional.ofNullable(clazz.cast(this.activeMembers()));
            }
            case "botMembers": {
                return Optional.ofNullable(clazz.cast(this.botMembers()));
            }
            case "activeDirectoryGuid": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryGuid()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "isDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "modified": {
                return Optional.ofNullable(clazz.cast(this.modified()));
            }
            case "securityGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.securityGroupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activeMembers", ACTIVE_MEMBERS_FIELD);
        map.put("botMembers", BOT_MEMBERS_FIELD);
        map.put("activeDirectoryGuid", ACTIVE_DIRECTORY_GUID_FIELD);
        map.put("id", ID_FIELD);
        map.put("isDefault", IS_DEFAULT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("modified", MODIFIED_FIELD);
        map.put("securityGroupSettings", SECURITY_GROUP_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroup, T> g) {
        return obj -> g.apply((SecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer activeMembers;
        private Integer botMembers;
        private String activeDirectoryGuid;
        private String id;
        private Boolean isDefault;
        private String name;
        private Integer modified;
        private SecurityGroupSettings securityGroupSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroup model) {
            this.activeMembers(model.activeMembers);
            this.botMembers(model.botMembers);
            this.activeDirectoryGuid(model.activeDirectoryGuid);
            this.id(model.id);
            this.isDefault(model.isDefault);
            this.name(model.name);
            this.modified(model.modified);
            this.securityGroupSettings(model.securityGroupSettings);
        }

        public final Integer getActiveMembers() {
            return this.activeMembers;
        }

        public final void setActiveMembers(Integer activeMembers) {
            this.activeMembers = activeMembers;
        }

        @Override
        public final Builder activeMembers(Integer activeMembers) {
            this.activeMembers = activeMembers;
            return this;
        }

        public final Integer getBotMembers() {
            return this.botMembers;
        }

        public final void setBotMembers(Integer botMembers) {
            this.botMembers = botMembers;
        }

        @Override
        public final Builder botMembers(Integer botMembers) {
            this.botMembers = botMembers;
            return this;
        }

        public final String getActiveDirectoryGuid() {
            return this.activeDirectoryGuid;
        }

        public final void setActiveDirectoryGuid(String activeDirectoryGuid) {
            this.activeDirectoryGuid = activeDirectoryGuid;
        }

        @Override
        public final Builder activeDirectoryGuid(String activeDirectoryGuid) {
            this.activeDirectoryGuid = activeDirectoryGuid;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getModified() {
            return this.modified;
        }

        public final void setModified(Integer modified) {
            this.modified = modified;
        }

        @Override
        public final Builder modified(Integer modified) {
            this.modified = modified;
            return this;
        }

        public final SecurityGroupSettings.Builder getSecurityGroupSettings() {
            return this.securityGroupSettings != null ? this.securityGroupSettings.toBuilder() : null;
        }

        public final void setSecurityGroupSettings(SecurityGroupSettings.BuilderImpl securityGroupSettings) {
            this.securityGroupSettings = securityGroupSettings != null ? securityGroupSettings.build() : null;
        }

        @Override
        public final Builder securityGroupSettings(SecurityGroupSettings securityGroupSettings) {
            this.securityGroupSettings = securityGroupSettings;
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroup> {
        public Builder activeMembers(Integer var1);

        public Builder botMembers(Integer var1);

        public Builder activeDirectoryGuid(String var1);

        public Builder id(String var1);

        public Builder isDefault(Boolean var1);

        public Builder name(String var1);

        public Builder modified(Integer var1);

        public Builder securityGroupSettings(SecurityGroupSettings var1);

        default public Builder securityGroupSettings(Consumer<SecurityGroupSettings.Builder> securityGroupSettings) {
            return this.securityGroupSettings((SecurityGroupSettings)((SecurityGroupSettings.Builder)SecurityGroupSettings.builder().applyMutation(securityGroupSettings)).build());
        }
    }
}

