/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.SortDirection;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityGroupUsersRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, ListSecurityGroupUsersRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(ListSecurityGroupUsersRequest.getter(ListSecurityGroupUsersRequest::networkId)).setter(ListSecurityGroupUsersRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(ListSecurityGroupUsersRequest.getter(ListSecurityGroupUsersRequest::groupId)).setter(ListSecurityGroupUsersRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("groupId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSecurityGroupUsersRequest.getter(ListSecurityGroupUsersRequest::nextToken)).setter(ListSecurityGroupUsersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListSecurityGroupUsersRequest.getter(ListSecurityGroupUsersRequest::maxResults)).setter(ListSecurityGroupUsersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SORT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortFields").getter(ListSecurityGroupUsersRequest.getter(ListSecurityGroupUsersRequest::sortFields)).setter(ListSecurityGroupUsersRequest.setter(Builder::sortFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortFields").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortDirection").getter(ListSecurityGroupUsersRequest.getter(ListSecurityGroupUsersRequest::sortDirectionAsString)).setter(ListSecurityGroupUsersRequest.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortDirection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, GROUP_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_FIELDS_FIELD, SORT_DIRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSecurityGroupUsersRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String groupId;
    private final String nextToken;
    private final Integer maxResults;
    private final String sortFields;
    private final String sortDirection;

    private ListSecurityGroupUsersRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.groupId = builder.groupId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortFields = builder.sortFields;
        this.sortDirection = builder.sortDirection;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String sortFields() {
        return this.sortFields;
    }

    public final SortDirection sortDirection() {
        return SortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityGroupUsersRequest)) {
            return false;
        }
        ListSecurityGroupUsersRequest other = (ListSecurityGroupUsersRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortFields(), other.sortFields()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityGroupUsersRequest").add("NetworkId", (Object)this.networkId()).add("GroupId", (Object)this.groupId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortFields", (Object)this.sortFields()).add("SortDirection", (Object)this.sortDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sortFields": {
                return Optional.ofNullable(clazz.cast(this.sortFields()));
            }
            case "sortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sortFields", SORT_FIELDS_FIELD);
        map.put("sortDirection", SORT_DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityGroupUsersRequest, T> g) {
        return obj -> g.apply((ListSecurityGroupUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String groupId;
        private String nextToken;
        private Integer maxResults;
        private String sortFields;
        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityGroupUsersRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.groupId(model.groupId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortFields(model.sortFields);
            this.sortDirection(model.sortDirection);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortFields() {
            return this.sortFields;
        }

        public final void setSortFields(String sortFields) {
            this.sortFields = sortFields;
        }

        @Override
        public final Builder sortFields(String sortFields) {
            this.sortFields = sortFields;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSecurityGroupUsersRequest build() {
            return new ListSecurityGroupUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityGroupUsersRequest> {
        public Builder networkId(String var1);

        public Builder groupId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortFields(String var1);

        public Builder sortDirection(String var1);

        public Builder sortDirection(SortDirection var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

