/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOidcInfoRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, GetOidcInfoRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::networkId)).setter(GetOidcInfoRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::clientId)).setter(GetOidcInfoRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientId").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::code)).setter(GetOidcInfoRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("code").build()}).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grantType").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::grantType)).setter(GetOidcInfoRequest.setter(Builder::grantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("grantType").build()}).build();
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redirectUri").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::redirectUri)).setter(GetOidcInfoRequest.setter(Builder::redirectUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("redirectUri").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::url)).setter(GetOidcInfoRequest.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("url").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSecret").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::clientSecret)).setter(GetOidcInfoRequest.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientSecret").build()}).build();
    private static final SdkField<String> CODE_VERIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeVerifier").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::codeVerifier)).setter(GetOidcInfoRequest.setter(Builder::codeVerifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("codeVerifier").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificate").getter(GetOidcInfoRequest.getter(GetOidcInfoRequest::certificate)).setter(GetOidcInfoRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("certificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, CLIENT_ID_FIELD, CODE_FIELD, GRANT_TYPE_FIELD, REDIRECT_URI_FIELD, URL_FIELD, CLIENT_SECRET_FIELD, CODE_VERIFIER_FIELD, CERTIFICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOidcInfoRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String clientId;
    private final String code;
    private final String grantType;
    private final String redirectUri;
    private final String url;
    private final String clientSecret;
    private final String codeVerifier;
    private final String certificate;

    private GetOidcInfoRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.clientId = builder.clientId;
        this.code = builder.code;
        this.grantType = builder.grantType;
        this.redirectUri = builder.redirectUri;
        this.url = builder.url;
        this.clientSecret = builder.clientSecret;
        this.codeVerifier = builder.codeVerifier;
        this.certificate = builder.certificate;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String code() {
        return this.code;
    }

    public final String grantType() {
        return this.grantType;
    }

    public final String redirectUri() {
        return this.redirectUri;
    }

    public final String url() {
        return this.url;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final String codeVerifier() {
        return this.codeVerifier;
    }

    public final String certificate() {
        return this.certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantType());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeVerifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOidcInfoRequest)) {
            return false;
        }
        GetOidcInfoRequest other = (GetOidcInfoRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.grantType(), other.grantType()) && Objects.equals(this.redirectUri(), other.redirectUri()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.codeVerifier(), other.codeVerifier()) && Objects.equals(this.certificate(), other.certificate());
    }

    public final String toString() {
        return ToString.builder((String)"GetOidcInfoRequest").add("NetworkId", (Object)this.networkId()).add("ClientId", (Object)this.clientId()).add("Code", (Object)this.code()).add("GrantType", (Object)this.grantType()).add("RedirectUri", (Object)this.redirectUri()).add("Url", (Object)this.url()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("CodeVerifier", (Object)this.codeVerifier()).add("Certificate", (Object)this.certificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "grantType": {
                return Optional.ofNullable(clazz.cast(this.grantType()));
            }
            case "redirectUri": {
                return Optional.ofNullable(clazz.cast(this.redirectUri()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "codeVerifier": {
                return Optional.ofNullable(clazz.cast(this.codeVerifier()));
            }
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("code", CODE_FIELD);
        map.put("grantType", GRANT_TYPE_FIELD);
        map.put("redirectUri", REDIRECT_URI_FIELD);
        map.put("url", URL_FIELD);
        map.put("clientSecret", CLIENT_SECRET_FIELD);
        map.put("codeVerifier", CODE_VERIFIER_FIELD);
        map.put("certificate", CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOidcInfoRequest, T> g) {
        return obj -> g.apply((GetOidcInfoRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String clientId;
        private String code;
        private String grantType;
        private String redirectUri;
        private String url;
        private String clientSecret;
        private String codeVerifier;
        private String certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOidcInfoRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.clientId(model.clientId);
            this.code(model.code);
            this.grantType(model.grantType);
            this.redirectUri(model.redirectUri);
            this.url(model.url);
            this.clientSecret(model.clientSecret);
            this.codeVerifier(model.codeVerifier);
            this.certificate(model.certificate);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public final String getRedirectUri() {
            return this.redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getCodeVerifier() {
            return this.codeVerifier;
        }

        public final void setCodeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
        }

        @Override
        public final Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOidcInfoRequest build() {
            return new GetOidcInfoRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOidcInfoRequest> {
        public Builder networkId(String var1);

        public Builder clientId(String var1);

        public Builder code(String var1);

        public Builder grantType(String var1);

        public Builder redirectUri(String var1);

        public Builder url(String var1);

        public Builder clientSecret(String var1);

        public Builder codeVerifier(String var1);

        public Builder certificate(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

