/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.BatchUnameErrorResponseItem;
import software.amazon.awssdk.services.wickr.model.BatchUnameErrorResponseItemsCopier;
import software.amazon.awssdk.services.wickr.model.BatchUnameSuccessResponseItem;
import software.amazon.awssdk.services.wickr.model.BatchUnameSuccessResponseItemsCopier;
import software.amazon.awssdk.services.wickr.model.WickrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchLookupUserUnameResponse
extends WickrResponse
implements ToCopyableBuilder<Builder, BatchLookupUserUnameResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(BatchLookupUserUnameResponse.getter(BatchLookupUserUnameResponse::message)).setter(BatchLookupUserUnameResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<BatchUnameSuccessResponseItem>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successful").getter(BatchLookupUserUnameResponse.getter(BatchLookupUserUnameResponse::successful)).setter(BatchLookupUserUnameResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUnameSuccessResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUnameErrorResponseItem>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failed").getter(BatchLookupUserUnameResponse.getter(BatchLookupUserUnameResponse::failed)).setter(BatchLookupUserUnameResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUnameErrorResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchLookupUserUnameResponse.memberNameToFieldInitializer();
    private final String message;
    private final List<BatchUnameSuccessResponseItem> successful;
    private final List<BatchUnameErrorResponseItem> failed;

    private BatchLookupUserUnameResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<BatchUnameSuccessResponseItem> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchUnameErrorResponseItem> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLookupUserUnameResponse)) {
            return false;
        }
        BatchLookupUserUnameResponse other = (BatchLookupUserUnameResponse)((Object)obj);
        return Objects.equals(this.message(), other.message()) && this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchLookupUserUnameResponse").add("Message", (Object)this.message()).add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", MESSAGE_FIELD);
        map.put("successful", SUCCESSFUL_FIELD);
        map.put("failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchLookupUserUnameResponse, T> g) {
        return obj -> g.apply((BatchLookupUserUnameResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrResponse.BuilderImpl
    implements Builder {
        private String message;
        private List<BatchUnameSuccessResponseItem> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUnameErrorResponseItem> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLookupUserUnameResponse model) {
            super(model);
            this.message(model.message);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<BatchUnameSuccessResponseItem.Builder> getSuccessful() {
            List<BatchUnameSuccessResponseItem.Builder> result = BatchUnameSuccessResponseItemsCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<BatchUnameSuccessResponseItem.BuilderImpl> successful) {
            this.successful = BatchUnameSuccessResponseItemsCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<BatchUnameSuccessResponseItem> successful) {
            this.successful = BatchUnameSuccessResponseItemsCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(BatchUnameSuccessResponseItem ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<BatchUnameSuccessResponseItem.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (BatchUnameSuccessResponseItem)((BatchUnameSuccessResponseItem.Builder)BatchUnameSuccessResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUnameErrorResponseItem.Builder> getFailed() {
            List<BatchUnameErrorResponseItem.Builder> result = BatchUnameErrorResponseItemsCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchUnameErrorResponseItem.BuilderImpl> failed) {
            this.failed = BatchUnameErrorResponseItemsCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchUnameErrorResponseItem> failed) {
            this.failed = BatchUnameErrorResponseItemsCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchUnameErrorResponseItem ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchUnameErrorResponseItem.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchUnameErrorResponseItem)((BatchUnameErrorResponseItem.Builder)BatchUnameErrorResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchLookupUserUnameResponse build() {
            return new BatchLookupUserUnameResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchLookupUserUnameResponse> {
        public Builder message(String var1);

        public Builder successful(Collection<BatchUnameSuccessResponseItem> var1);

        public Builder successful(BatchUnameSuccessResponseItem ... var1);

        public Builder successful(Consumer<BatchUnameSuccessResponseItem.Builder> ... var1);

        public Builder failed(Collection<BatchUnameErrorResponseItem> var1);

        public Builder failed(BatchUnameErrorResponseItem ... var1);

        public Builder failed(Consumer<BatchUnameErrorResponseItem.Builder> ... var1);
    }
}

