/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wickr.WickrClient;
import software.amazon.awssdk.services.wickr.internal.UserAgentUtils;
import software.amazon.awssdk.services.wickr.model.BasicDeviceObject;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserRequest;
import software.amazon.awssdk.services.wickr.model.ListDevicesForUserResponse;

public class ListDevicesForUserIterable
implements SdkIterable<ListDevicesForUserResponse> {
    private final WickrClient client;
    private final ListDevicesForUserRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevicesForUserIterable(WickrClient client, ListDevicesForUserRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDevicesForUserResponseFetcher();
    }

    public Iterator<ListDevicesForUserResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BasicDeviceObject> devices() {
        Function<ListDevicesForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDevicesForUserResponseFetcher
    implements SyncPageFetcher<ListDevicesForUserResponse> {
        private ListDevicesForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesForUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevicesForUserResponse nextPage(ListDevicesForUserResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesForUserIterable.this.client.listDevicesForUser(ListDevicesForUserIterable.this.firstRequest);
            }
            return ListDevicesForUserIterable.this.client.listDevicesForUser((ListDevicesForUserRequest)((Object)ListDevicesForUserIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

