/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.ErrorDetail;
import software.amazon.awssdk.services.wickr.model.ErrorDetailListCopier;
import software.amazon.awssdk.services.wickr.model.WickrException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationErrorException
extends WickrException
implements ToCopyableBuilder<Builder, ValidationErrorException> {
    private static final SdkField<List<ErrorDetail>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reasons").getter(ValidationErrorException.getter(ValidationErrorException::reasons)).setter(ValidationErrorException.setter(Builder::reasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationErrorException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ErrorDetail> reasons;

    private ValidationErrorException(BuilderImpl builder) {
        super(builder);
        this.reasons = builder.reasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public List<ErrorDetail> reasons() {
        return this.reasons;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ErrorDetail>>> map = new HashMap<String, SdkField<List<ErrorDetail>>>();
        map.put("reasons", REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationErrorException, T> g) {
        return obj -> g.apply((ValidationErrorException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrException.BuilderImpl
    implements Builder {
        private List<ErrorDetail> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationErrorException model) {
            super(model);
            this.reasons(model.reasons);
        }

        public final List<ErrorDetail.Builder> getReasons() {
            List<ErrorDetail.Builder> result = ErrorDetailListCopier.copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<ErrorDetail.BuilderImpl> reasons) {
            this.reasons = ErrorDetailListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<ErrorDetail> reasons) {
            this.reasons = ErrorDetailListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(ErrorDetail ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<ErrorDetail.Builder> ... reasons) {
            this.reasons(Stream.of(reasons).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ValidationErrorException build() {
            return new ValidationErrorException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationErrorException>,
    WickrException.Builder {
        public Builder reasons(Collection<ErrorDetail> var1);

        public Builder reasons(ErrorDetail ... var1);

        public Builder reasons(Consumer<ErrorDetail.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

