/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceReason;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChoiceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChoiceUpdate> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ChoiceUpdate.getter(ChoiceUpdate::statusAsString)).setter(ChoiceUpdate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(ChoiceUpdate.getter(ChoiceUpdate::reasonAsString)).setter(ChoiceUpdate.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(ChoiceUpdate.getter(ChoiceUpdate::notes)).setter(ChoiceUpdate.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD, NOTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChoiceUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String reason;
    private final String notes;

    private ChoiceUpdate(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.notes = builder.notes;
    }

    public final ChoiceStatus status() {
        return ChoiceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ChoiceReason reason() {
        return ChoiceReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final String notes() {
        return this.notes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChoiceUpdate)) {
            return false;
        }
        ChoiceUpdate other = (ChoiceUpdate)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.notes(), other.notes());
    }

    public final String toString() {
        return ToString.builder((String)"ChoiceUpdate").add("Status", (Object)this.statusAsString()).add("Reason", (Object)this.reasonAsString()).add("Notes", (Object)this.notes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Status", STATUS_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("Notes", NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChoiceUpdate, T> g) {
        return obj -> g.apply((ChoiceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String reason;
        private String notes;

        private BuilderImpl() {
        }

        private BuilderImpl(ChoiceUpdate model) {
            this.status(model.status);
            this.reason(model.reason);
            this.notes(model.notes);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChoiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ChoiceReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public ChoiceUpdate build() {
            return new ChoiceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChoiceUpdate> {
        public Builder status(String var1);

        public Builder status(ChoiceStatus var1);

        public Builder reason(String var1);

        public Builder reason(ChoiceReason var1);

        public Builder notes(String var1);
    }
}

