/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceImprovementPlan;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceImprovementPlansCopier;
import software.amazon.awssdk.services.wellarchitected.model.JiraConfiguration;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImprovementSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImprovementSummary> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(ImprovementSummary.getter(ImprovementSummary::questionId)).setter(ImprovementSummary.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(ImprovementSummary.getter(ImprovementSummary::pillarId)).setter(ImprovementSummary.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionTitle").getter(ImprovementSummary.getter(ImprovementSummary::questionTitle)).setter(ImprovementSummary.setter(Builder::questionTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()}).build();
    private static final SdkField<String> RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Risk").getter(ImprovementSummary.getter(ImprovementSummary::riskAsString)).setter(ImprovementSummary.setter(Builder::risk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()}).build();
    private static final SdkField<String> IMPROVEMENT_PLAN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImprovementPlanUrl").getter(ImprovementSummary.getter(ImprovementSummary::improvementPlanUrl)).setter(ImprovementSummary.setter(Builder::improvementPlanUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlanUrl").build()}).build();
    private static final SdkField<List<ChoiceImprovementPlan>> IMPROVEMENT_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImprovementPlans").getter(ImprovementSummary.getter(ImprovementSummary::improvementPlans)).setter(ImprovementSummary.setter(Builder::improvementPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChoiceImprovementPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JiraConfiguration> JIRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JiraConfiguration").getter(ImprovementSummary.getter(ImprovementSummary::jiraConfiguration)).setter(ImprovementSummary.setter(Builder::jiraConfiguration)).constructor(JiraConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, RISK_FIELD, IMPROVEMENT_PLAN_URL_FIELD, IMPROVEMENT_PLANS_FIELD, JIRA_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImprovementSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String pillarId;
    private final String questionTitle;
    private final String risk;
    private final String improvementPlanUrl;
    private final List<ChoiceImprovementPlan> improvementPlans;
    private final JiraConfiguration jiraConfiguration;

    private ImprovementSummary(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.risk = builder.risk;
        this.improvementPlanUrl = builder.improvementPlanUrl;
        this.improvementPlans = builder.improvementPlans;
        this.jiraConfiguration = builder.jiraConfiguration;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String questionTitle() {
        return this.questionTitle;
    }

    public final Risk risk() {
        return Risk.fromValue(this.risk);
    }

    public final String riskAsString() {
        return this.risk;
    }

    public final String improvementPlanUrl() {
        return this.improvementPlanUrl;
    }

    public final boolean hasImprovementPlans() {
        return this.improvementPlans != null && !(this.improvementPlans instanceof SdkAutoConstructList);
    }

    public final List<ChoiceImprovementPlan> improvementPlans() {
        return this.improvementPlans;
    }

    public final JiraConfiguration jiraConfiguration() {
        return this.jiraConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementPlanUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImprovementPlans() ? this.improvementPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImprovementSummary)) {
            return false;
        }
        ImprovementSummary other = (ImprovementSummary)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.questionTitle(), other.questionTitle()) && Objects.equals(this.riskAsString(), other.riskAsString()) && Objects.equals(this.improvementPlanUrl(), other.improvementPlanUrl()) && this.hasImprovementPlans() == other.hasImprovementPlans() && Objects.equals(this.improvementPlans(), other.improvementPlans()) && Objects.equals(this.jiraConfiguration(), other.jiraConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ImprovementSummary").add("QuestionId", (Object)this.questionId()).add("PillarId", (Object)this.pillarId()).add("QuestionTitle", (Object)this.questionTitle()).add("Risk", (Object)this.riskAsString()).add("ImprovementPlanUrl", (Object)this.improvementPlanUrl()).add("ImprovementPlans", this.hasImprovementPlans() ? this.improvementPlans() : null).add("JiraConfiguration", (Object)this.jiraConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "QuestionTitle": {
                return Optional.ofNullable(clazz.cast(this.questionTitle()));
            }
            case "Risk": {
                return Optional.ofNullable(clazz.cast(this.riskAsString()));
            }
            case "ImprovementPlanUrl": {
                return Optional.ofNullable(clazz.cast(this.improvementPlanUrl()));
            }
            case "ImprovementPlans": {
                return Optional.ofNullable(clazz.cast(this.improvementPlans()));
            }
            case "JiraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jiraConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionTitle", QUESTION_TITLE_FIELD);
        map.put("Risk", RISK_FIELD);
        map.put("ImprovementPlanUrl", IMPROVEMENT_PLAN_URL_FIELD);
        map.put("ImprovementPlans", IMPROVEMENT_PLANS_FIELD);
        map.put("JiraConfiguration", JIRA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImprovementSummary, T> g) {
        return obj -> g.apply((ImprovementSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String pillarId;
        private String questionTitle;
        private String risk;
        private String improvementPlanUrl;
        private List<ChoiceImprovementPlan> improvementPlans = DefaultSdkAutoConstructList.getInstance();
        private JiraConfiguration jiraConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ImprovementSummary model) {
            this.questionId(model.questionId);
            this.pillarId(model.pillarId);
            this.questionTitle(model.questionTitle);
            this.risk(model.risk);
            this.improvementPlanUrl(model.improvementPlanUrl);
            this.improvementPlans(model.improvementPlans);
            this.jiraConfiguration(model.jiraConfiguration);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionTitle() {
            return this.questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final String getRisk() {
            return this.risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final String getImprovementPlanUrl() {
            return this.improvementPlanUrl;
        }

        public final void setImprovementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
        }

        @Override
        public final Builder improvementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
            return this;
        }

        public final List<ChoiceImprovementPlan.Builder> getImprovementPlans() {
            List<ChoiceImprovementPlan.Builder> result = ChoiceImprovementPlansCopier.copyToBuilder(this.improvementPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImprovementPlans(Collection<ChoiceImprovementPlan.BuilderImpl> improvementPlans) {
            this.improvementPlans = ChoiceImprovementPlansCopier.copyFromBuilder(improvementPlans);
        }

        @Override
        public final Builder improvementPlans(Collection<ChoiceImprovementPlan> improvementPlans) {
            this.improvementPlans = ChoiceImprovementPlansCopier.copy(improvementPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder improvementPlans(ChoiceImprovementPlan ... improvementPlans) {
            this.improvementPlans(Arrays.asList(improvementPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder improvementPlans(Consumer<ChoiceImprovementPlan.Builder> ... improvementPlans) {
            this.improvementPlans(Stream.of(improvementPlans).map(c -> (ChoiceImprovementPlan)((ChoiceImprovementPlan.Builder)ChoiceImprovementPlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final JiraConfiguration.Builder getJiraConfiguration() {
            return this.jiraConfiguration != null ? this.jiraConfiguration.toBuilder() : null;
        }

        public final void setJiraConfiguration(JiraConfiguration.BuilderImpl jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration != null ? jiraConfiguration.build() : null;
        }

        @Override
        public final Builder jiraConfiguration(JiraConfiguration jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration;
            return this;
        }

        public ImprovementSummary build() {
            return new ImprovementSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImprovementSummary> {
        public Builder questionId(String var1);

        public Builder pillarId(String var1);

        public Builder questionTitle(String var1);

        public Builder risk(String var1);

        public Builder risk(Risk var1);

        public Builder improvementPlanUrl(String var1);

        public Builder improvementPlans(Collection<ChoiceImprovementPlan> var1);

        public Builder improvementPlans(ChoiceImprovementPlan ... var1);

        public Builder improvementPlans(Consumer<ChoiceImprovementPlan.Builder> ... var1);

        public Builder jiraConfiguration(JiraConfiguration var1);

        default public Builder jiraConfiguration(Consumer<JiraConfiguration.Builder> jiraConfiguration) {
            return this.jiraConfiguration((JiraConfiguration)((JiraConfiguration.Builder)JiraConfiguration.builder().applyMutation(jiraConfiguration)).build());
        }
    }
}

