/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ImprovementSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ImprovementSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLensReviewImprovementsResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListLensReviewImprovementsResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListLensReviewImprovementsResponse.getter(ListLensReviewImprovementsResponse::workloadId)).setter(ListLensReviewImprovementsResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(ListLensReviewImprovementsResponse.getter(ListLensReviewImprovementsResponse::milestoneNumber)).setter(ListLensReviewImprovementsResponse.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(ListLensReviewImprovementsResponse.getter(ListLensReviewImprovementsResponse::lensAlias)).setter(ListLensReviewImprovementsResponse.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(ListLensReviewImprovementsResponse.getter(ListLensReviewImprovementsResponse::lensArn)).setter(ListLensReviewImprovementsResponse.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<List<ImprovementSummary>> IMPROVEMENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImprovementSummaries").getter(ListLensReviewImprovementsResponse.getter(ListLensReviewImprovementsResponse::improvementSummaries)).setter(ListLensReviewImprovementsResponse.setter(Builder::improvementSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImprovementSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLensReviewImprovementsResponse.getter(ListLensReviewImprovementsResponse::nextToken)).setter(ListLensReviewImprovementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_NUMBER_FIELD, LENS_ALIAS_FIELD, LENS_ARN_FIELD, IMPROVEMENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLensReviewImprovementsResponse.memberNameToFieldInitializer();
    private final String workloadId;
    private final Integer milestoneNumber;
    private final String lensAlias;
    private final String lensArn;
    private final List<ImprovementSummary> improvementSummaries;
    private final String nextToken;

    private ListLensReviewImprovementsResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.improvementSummaries = builder.improvementSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final boolean hasImprovementSummaries() {
        return this.improvementSummaries != null && !(this.improvementSummaries instanceof SdkAutoConstructList);
    }

    public final List<ImprovementSummary> improvementSummaries() {
        return this.improvementSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImprovementSummaries() ? this.improvementSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensReviewImprovementsResponse)) {
            return false;
        }
        ListLensReviewImprovementsResponse other = (ListLensReviewImprovementsResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && this.hasImprovementSummaries() == other.hasImprovementSummaries() && Objects.equals(this.improvementSummaries(), other.improvementSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLensReviewImprovementsResponse").add("WorkloadId", (Object)this.workloadId()).add("MilestoneNumber", (Object)this.milestoneNumber()).add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("ImprovementSummaries", this.hasImprovementSummaries() ? this.improvementSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "ImprovementSummaries": {
                return Optional.ofNullable(clazz.cast(this.improvementSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("MilestoneNumber", MILESTONE_NUMBER_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("ImprovementSummaries", IMPROVEMENT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLensReviewImprovementsResponse, T> g) {
        return obj -> g.apply((ListLensReviewImprovementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private Integer milestoneNumber;
        private String lensAlias;
        private String lensArn;
        private List<ImprovementSummary> improvementSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensReviewImprovementsResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestoneNumber(model.milestoneNumber);
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.improvementSummaries(model.improvementSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final List<ImprovementSummary.Builder> getImprovementSummaries() {
            List<ImprovementSummary.Builder> result = ImprovementSummariesCopier.copyToBuilder(this.improvementSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImprovementSummaries(Collection<ImprovementSummary.BuilderImpl> improvementSummaries) {
            this.improvementSummaries = ImprovementSummariesCopier.copyFromBuilder(improvementSummaries);
        }

        @Override
        public final Builder improvementSummaries(Collection<ImprovementSummary> improvementSummaries) {
            this.improvementSummaries = ImprovementSummariesCopier.copy(improvementSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder improvementSummaries(ImprovementSummary ... improvementSummaries) {
            this.improvementSummaries(Arrays.asList(improvementSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder improvementSummaries(Consumer<ImprovementSummary.Builder> ... improvementSummaries) {
            this.improvementSummaries(Stream.of(improvementSummaries).map(c -> (ImprovementSummary)((ImprovementSummary.Builder)ImprovementSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLensReviewImprovementsResponse build() {
            return new ListLensReviewImprovementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLensReviewImprovementsResponse> {
        public Builder workloadId(String var1);

        public Builder milestoneNumber(Integer var1);

        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder improvementSummaries(Collection<ImprovementSummary> var1);

        public Builder improvementSummaries(ImprovementSummary ... var1);

        public Builder improvementSummaries(Consumer<ImprovementSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

