/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.AnswerReason;
import software.amazon.awssdk.services.wellarchitected.model.Choice;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswer;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswersCopier;
import software.amazon.awssdk.services.wellarchitected.model.ChoicesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerStatus;
import software.amazon.awssdk.services.wellarchitected.model.SelectedChoicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewTemplateAnswer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewTemplateAnswer> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::questionId)).setter(ReviewTemplateAnswer.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::pillarId)).setter(ReviewTemplateAnswer.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionTitle").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::questionTitle)).setter(ReviewTemplateAnswer.setter(Builder::questionTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()}).build();
    private static final SdkField<String> QUESTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionDescription").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::questionDescription)).setter(ReviewTemplateAnswer.setter(Builder::questionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDescription").build()}).build();
    private static final SdkField<String> IMPROVEMENT_PLAN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImprovementPlanUrl").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::improvementPlanUrl)).setter(ReviewTemplateAnswer.setter(Builder::improvementPlanUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlanUrl").build()}).build();
    private static final SdkField<String> HELPFUL_RESOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HelpfulResourceUrl").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::helpfulResourceUrl)).setter(ReviewTemplateAnswer.setter(Builder::helpfulResourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResourceUrl").build()}).build();
    private static final SdkField<String> HELPFUL_RESOURCE_DISPLAY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HelpfulResourceDisplayText").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::helpfulResourceDisplayText)).setter(ReviewTemplateAnswer.setter(Builder::helpfulResourceDisplayText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResourceDisplayText").build()}).build();
    private static final SdkField<List<Choice>> CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Choices").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::choices)).setter(ReviewTemplateAnswer.setter(Builder::choices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Choices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Choice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoices").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::selectedChoices)).setter(ReviewTemplateAnswer.setter(Builder::selectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ChoiceAnswer>> CHOICE_ANSWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChoiceAnswers").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::choiceAnswers)).setter(ReviewTemplateAnswer.setter(Builder::choiceAnswers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceAnswers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChoiceAnswer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsApplicable").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::isApplicable)).setter(ReviewTemplateAnswer.setter(Builder::isApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()}).build();
    private static final SdkField<String> ANSWER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnswerStatus").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::answerStatusAsString)).setter(ReviewTemplateAnswer.setter(Builder::answerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerStatus").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::notes)).setter(ReviewTemplateAnswer.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(ReviewTemplateAnswer.getter(ReviewTemplateAnswer::reasonAsString)).setter(ReviewTemplateAnswer.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, QUESTION_DESCRIPTION_FIELD, IMPROVEMENT_PLAN_URL_FIELD, HELPFUL_RESOURCE_URL_FIELD, HELPFUL_RESOURCE_DISPLAY_TEXT_FIELD, CHOICES_FIELD, SELECTED_CHOICES_FIELD, CHOICE_ANSWERS_FIELD, IS_APPLICABLE_FIELD, ANSWER_STATUS_FIELD, NOTES_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReviewTemplateAnswer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String pillarId;
    private final String questionTitle;
    private final String questionDescription;
    private final String improvementPlanUrl;
    private final String helpfulResourceUrl;
    private final String helpfulResourceDisplayText;
    private final List<Choice> choices;
    private final List<String> selectedChoices;
    private final List<ChoiceAnswer> choiceAnswers;
    private final Boolean isApplicable;
    private final String answerStatus;
    private final String notes;
    private final String reason;

    private ReviewTemplateAnswer(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.questionDescription = builder.questionDescription;
        this.improvementPlanUrl = builder.improvementPlanUrl;
        this.helpfulResourceUrl = builder.helpfulResourceUrl;
        this.helpfulResourceDisplayText = builder.helpfulResourceDisplayText;
        this.choices = builder.choices;
        this.selectedChoices = builder.selectedChoices;
        this.choiceAnswers = builder.choiceAnswers;
        this.isApplicable = builder.isApplicable;
        this.answerStatus = builder.answerStatus;
        this.notes = builder.notes;
        this.reason = builder.reason;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String questionTitle() {
        return this.questionTitle;
    }

    public final String questionDescription() {
        return this.questionDescription;
    }

    public final String improvementPlanUrl() {
        return this.improvementPlanUrl;
    }

    public final String helpfulResourceUrl() {
        return this.helpfulResourceUrl;
    }

    public final String helpfulResourceDisplayText() {
        return this.helpfulResourceDisplayText;
    }

    public final boolean hasChoices() {
        return this.choices != null && !(this.choices instanceof SdkAutoConstructList);
    }

    public final List<Choice> choices() {
        return this.choices;
    }

    public final boolean hasSelectedChoices() {
        return this.selectedChoices != null && !(this.selectedChoices instanceof SdkAutoConstructList);
    }

    public final List<String> selectedChoices() {
        return this.selectedChoices;
    }

    public final boolean hasChoiceAnswers() {
        return this.choiceAnswers != null && !(this.choiceAnswers instanceof SdkAutoConstructList);
    }

    public final List<ChoiceAnswer> choiceAnswers() {
        return this.choiceAnswers;
    }

    public final Boolean isApplicable() {
        return this.isApplicable;
    }

    public final ReviewTemplateAnswerStatus answerStatus() {
        return ReviewTemplateAnswerStatus.fromValue(this.answerStatus);
    }

    public final String answerStatusAsString() {
        return this.answerStatus;
    }

    public final String notes() {
        return this.notes;
    }

    public final AnswerReason reason() {
        return AnswerReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementPlanUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.helpfulResourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.helpfulResourceDisplayText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChoices() ? this.choices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoices() ? this.selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChoiceAnswers() ? this.choiceAnswers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplateAnswer)) {
            return false;
        }
        ReviewTemplateAnswer other = (ReviewTemplateAnswer)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.questionTitle(), other.questionTitle()) && Objects.equals(this.questionDescription(), other.questionDescription()) && Objects.equals(this.improvementPlanUrl(), other.improvementPlanUrl()) && Objects.equals(this.helpfulResourceUrl(), other.helpfulResourceUrl()) && Objects.equals(this.helpfulResourceDisplayText(), other.helpfulResourceDisplayText()) && this.hasChoices() == other.hasChoices() && Objects.equals(this.choices(), other.choices()) && this.hasSelectedChoices() == other.hasSelectedChoices() && Objects.equals(this.selectedChoices(), other.selectedChoices()) && this.hasChoiceAnswers() == other.hasChoiceAnswers() && Objects.equals(this.choiceAnswers(), other.choiceAnswers()) && Objects.equals(this.isApplicable(), other.isApplicable()) && Objects.equals(this.answerStatusAsString(), other.answerStatusAsString()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.reasonAsString(), other.reasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewTemplateAnswer").add("QuestionId", (Object)this.questionId()).add("PillarId", (Object)this.pillarId()).add("QuestionTitle", (Object)this.questionTitle()).add("QuestionDescription", (Object)this.questionDescription()).add("ImprovementPlanUrl", (Object)this.improvementPlanUrl()).add("HelpfulResourceUrl", (Object)this.helpfulResourceUrl()).add("HelpfulResourceDisplayText", (Object)this.helpfulResourceDisplayText()).add("Choices", this.hasChoices() ? this.choices() : null).add("SelectedChoices", this.hasSelectedChoices() ? this.selectedChoices() : null).add("ChoiceAnswers", this.hasChoiceAnswers() ? this.choiceAnswers() : null).add("IsApplicable", (Object)this.isApplicable()).add("AnswerStatus", (Object)this.answerStatusAsString()).add("Notes", (Object)this.notes()).add("Reason", (Object)this.reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "QuestionTitle": {
                return Optional.ofNullable(clazz.cast(this.questionTitle()));
            }
            case "QuestionDescription": {
                return Optional.ofNullable(clazz.cast(this.questionDescription()));
            }
            case "ImprovementPlanUrl": {
                return Optional.ofNullable(clazz.cast(this.improvementPlanUrl()));
            }
            case "HelpfulResourceUrl": {
                return Optional.ofNullable(clazz.cast(this.helpfulResourceUrl()));
            }
            case "HelpfulResourceDisplayText": {
                return Optional.ofNullable(clazz.cast(this.helpfulResourceDisplayText()));
            }
            case "Choices": {
                return Optional.ofNullable(clazz.cast(this.choices()));
            }
            case "SelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.selectedChoices()));
            }
            case "ChoiceAnswers": {
                return Optional.ofNullable(clazz.cast(this.choiceAnswers()));
            }
            case "IsApplicable": {
                return Optional.ofNullable(clazz.cast(this.isApplicable()));
            }
            case "AnswerStatus": {
                return Optional.ofNullable(clazz.cast(this.answerStatusAsString()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionTitle", QUESTION_TITLE_FIELD);
        map.put("QuestionDescription", QUESTION_DESCRIPTION_FIELD);
        map.put("ImprovementPlanUrl", IMPROVEMENT_PLAN_URL_FIELD);
        map.put("HelpfulResourceUrl", HELPFUL_RESOURCE_URL_FIELD);
        map.put("HelpfulResourceDisplayText", HELPFUL_RESOURCE_DISPLAY_TEXT_FIELD);
        map.put("Choices", CHOICES_FIELD);
        map.put("SelectedChoices", SELECTED_CHOICES_FIELD);
        map.put("ChoiceAnswers", CHOICE_ANSWERS_FIELD);
        map.put("IsApplicable", IS_APPLICABLE_FIELD);
        map.put("AnswerStatus", ANSWER_STATUS_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplateAnswer, T> g) {
        return obj -> g.apply((ReviewTemplateAnswer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String pillarId;
        private String questionTitle;
        private String questionDescription;
        private String improvementPlanUrl;
        private String helpfulResourceUrl;
        private String helpfulResourceDisplayText;
        private List<Choice> choices = DefaultSdkAutoConstructList.getInstance();
        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();
        private List<ChoiceAnswer> choiceAnswers = DefaultSdkAutoConstructList.getInstance();
        private Boolean isApplicable;
        private String answerStatus;
        private String notes;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplateAnswer model) {
            this.questionId(model.questionId);
            this.pillarId(model.pillarId);
            this.questionTitle(model.questionTitle);
            this.questionDescription(model.questionDescription);
            this.improvementPlanUrl(model.improvementPlanUrl);
            this.helpfulResourceUrl(model.helpfulResourceUrl);
            this.helpfulResourceDisplayText(model.helpfulResourceDisplayText);
            this.choices(model.choices);
            this.selectedChoices(model.selectedChoices);
            this.choiceAnswers(model.choiceAnswers);
            this.isApplicable(model.isApplicable);
            this.answerStatus(model.answerStatus);
            this.notes(model.notes);
            this.reason(model.reason);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionTitle() {
            return this.questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final String getQuestionDescription() {
            return this.questionDescription;
        }

        public final void setQuestionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
        }

        @Override
        public final Builder questionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
            return this;
        }

        public final String getImprovementPlanUrl() {
            return this.improvementPlanUrl;
        }

        public final void setImprovementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
        }

        @Override
        public final Builder improvementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
            return this;
        }

        public final String getHelpfulResourceUrl() {
            return this.helpfulResourceUrl;
        }

        public final void setHelpfulResourceUrl(String helpfulResourceUrl) {
            this.helpfulResourceUrl = helpfulResourceUrl;
        }

        @Override
        public final Builder helpfulResourceUrl(String helpfulResourceUrl) {
            this.helpfulResourceUrl = helpfulResourceUrl;
            return this;
        }

        public final String getHelpfulResourceDisplayText() {
            return this.helpfulResourceDisplayText;
        }

        public final void setHelpfulResourceDisplayText(String helpfulResourceDisplayText) {
            this.helpfulResourceDisplayText = helpfulResourceDisplayText;
        }

        @Override
        public final Builder helpfulResourceDisplayText(String helpfulResourceDisplayText) {
            this.helpfulResourceDisplayText = helpfulResourceDisplayText;
            return this;
        }

        public final List<Choice.Builder> getChoices() {
            List<Choice.Builder> result = ChoicesCopier.copyToBuilder(this.choices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoices(Collection<Choice.BuilderImpl> choices) {
            this.choices = ChoicesCopier.copyFromBuilder(choices);
        }

        @Override
        public final Builder choices(Collection<Choice> choices) {
            this.choices = ChoicesCopier.copy(choices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Choice ... choices) {
            this.choices(Arrays.asList(choices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Consumer<Choice.Builder> ... choices) {
            this.choices(Stream.of(choices).map(c -> (Choice)((Choice.Builder)Choice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedChoices() {
            if (this.selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoices;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String ... selectedChoices) {
            this.selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final List<ChoiceAnswer.Builder> getChoiceAnswers() {
            List<ChoiceAnswer.Builder> result = ChoiceAnswersCopier.copyToBuilder(this.choiceAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoiceAnswers(Collection<ChoiceAnswer.BuilderImpl> choiceAnswers) {
            this.choiceAnswers = ChoiceAnswersCopier.copyFromBuilder(choiceAnswers);
        }

        @Override
        public final Builder choiceAnswers(Collection<ChoiceAnswer> choiceAnswers) {
            this.choiceAnswers = ChoiceAnswersCopier.copy(choiceAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswers(ChoiceAnswer ... choiceAnswers) {
            this.choiceAnswers(Arrays.asList(choiceAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswers(Consumer<ChoiceAnswer.Builder> ... choiceAnswers) {
            this.choiceAnswers(Stream.of(choiceAnswers).map(c -> (ChoiceAnswer)((ChoiceAnswer.Builder)ChoiceAnswer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsApplicable() {
            return this.isApplicable;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final String getAnswerStatus() {
            return this.answerStatus;
        }

        public final void setAnswerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
        }

        @Override
        public final Builder answerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
            return this;
        }

        @Override
        public final Builder answerStatus(ReviewTemplateAnswerStatus answerStatus) {
            this.answerStatus(answerStatus == null ? null : answerStatus.toString());
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(AnswerReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public ReviewTemplateAnswer build() {
            return new ReviewTemplateAnswer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewTemplateAnswer> {
        public Builder questionId(String var1);

        public Builder pillarId(String var1);

        public Builder questionTitle(String var1);

        public Builder questionDescription(String var1);

        public Builder improvementPlanUrl(String var1);

        public Builder helpfulResourceUrl(String var1);

        public Builder helpfulResourceDisplayText(String var1);

        public Builder choices(Collection<Choice> var1);

        public Builder choices(Choice ... var1);

        public Builder choices(Consumer<Choice.Builder> ... var1);

        public Builder selectedChoices(Collection<String> var1);

        public Builder selectedChoices(String ... var1);

        public Builder choiceAnswers(Collection<ChoiceAnswer> var1);

        public Builder choiceAnswers(ChoiceAnswer ... var1);

        public Builder choiceAnswers(Consumer<ChoiceAnswer.Builder> ... var1);

        public Builder isApplicable(Boolean var1);

        public Builder answerStatus(String var1);

        public Builder answerStatus(ReviewTemplateAnswerStatus var1);

        public Builder notes(String var1);

        public Builder reason(String var1);

        public Builder reason(AnswerReason var1);
    }
}

