/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.Answer;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnswerResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, GetAnswerResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(GetAnswerResponse.getter(GetAnswerResponse::workloadId)).setter(GetAnswerResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(GetAnswerResponse.getter(GetAnswerResponse::milestoneNumber)).setter(GetAnswerResponse.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(GetAnswerResponse.getter(GetAnswerResponse::lensAlias)).setter(GetAnswerResponse.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(GetAnswerResponse.getter(GetAnswerResponse::lensArn)).setter(GetAnswerResponse.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<Answer> ANSWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Answer").getter(GetAnswerResponse.getter(GetAnswerResponse::answer)).setter(GetAnswerResponse.setter(Builder::answer)).constructor(Answer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_NUMBER_FIELD, LENS_ALIAS_FIELD, LENS_ARN_FIELD, ANSWER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WorkloadId", WORKLOAD_ID_FIELD);
            this.put("MilestoneNumber", MILESTONE_NUMBER_FIELD);
            this.put("LensAlias", LENS_ALIAS_FIELD);
            this.put("LensArn", LENS_ARN_FIELD);
            this.put("Answer", ANSWER_FIELD);
        }
    });
    private final String workloadId;
    private final Integer milestoneNumber;
    private final String lensAlias;
    private final String lensArn;
    private final Answer answer;

    private GetAnswerResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.answer = builder.answer;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final Answer answer() {
        return this.answer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.answer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnswerResponse)) {
            return false;
        }
        GetAnswerResponse other = (GetAnswerResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.answer(), other.answer());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnswerResponse").add("WorkloadId", (Object)this.workloadId()).add("MilestoneNumber", (Object)this.milestoneNumber()).add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("Answer", (Object)this.answer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "Answer": {
                return Optional.ofNullable(clazz.cast(this.answer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAnswerResponse, T> g) {
        return obj -> g.apply((GetAnswerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private Integer milestoneNumber;
        private String lensAlias;
        private String lensArn;
        private Answer answer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnswerResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestoneNumber(model.milestoneNumber);
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.answer(model.answer);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final Answer.Builder getAnswer() {
            return this.answer != null ? this.answer.toBuilder() : null;
        }

        public final void setAnswer(Answer.BuilderImpl answer) {
            this.answer = answer != null ? answer.build() : null;
        }

        @Override
        public final Builder answer(Answer answer) {
            this.answer = answer;
            return this;
        }

        @Override
        public GetAnswerResponse build() {
            return new GetAnswerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnswerResponse> {
        public Builder workloadId(String var1);

        public Builder milestoneNumber(Integer var1);

        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder answer(Answer var1);

        default public Builder answer(Consumer<Answer.Builder> answer) {
            return this.answer((Answer)((Answer.Builder)Answer.builder().applyMutation(answer)).build());
        }
    }
}

