/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.LensSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.LensSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLensesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListLensesResponse> {
    private static final SdkField<List<LensSummary>> LENS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LensSummaries").getter(ListLensesResponse.getter(ListLensesResponse::lensSummaries)).setter(ListLensesResponse.setter(Builder::lensSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LensSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLensesResponse.getter(ListLensesResponse::nextToken)).setter(ListLensesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<LensSummary> lensSummaries;
    private final String nextToken;

    private ListLensesResponse(BuilderImpl builder) {
        super(builder);
        this.lensSummaries = builder.lensSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLensSummaries() {
        return this.lensSummaries != null && !(this.lensSummaries instanceof SdkAutoConstructList);
    }

    public final List<LensSummary> lensSummaries() {
        return this.lensSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLensSummaries() ? this.lensSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensesResponse)) {
            return false;
        }
        ListLensesResponse other = (ListLensesResponse)((Object)obj);
        return this.hasLensSummaries() == other.hasLensSummaries() && Objects.equals(this.lensSummaries(), other.lensSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLensesResponse").add("LensSummaries", this.hasLensSummaries() ? this.lensSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensSummaries": {
                return Optional.ofNullable(clazz.cast(this.lensSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLensesResponse, T> g) {
        return obj -> g.apply((ListLensesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<LensSummary> lensSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensesResponse model) {
            super(model);
            this.lensSummaries(model.lensSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<LensSummary.Builder> getLensSummaries() {
            List<LensSummary.Builder> result = LensSummariesCopier.copyToBuilder(this.lensSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLensSummaries(Collection<LensSummary.BuilderImpl> lensSummaries) {
            this.lensSummaries = LensSummariesCopier.copyFromBuilder(lensSummaries);
        }

        @Override
        public final Builder lensSummaries(Collection<LensSummary> lensSummaries) {
            this.lensSummaries = LensSummariesCopier.copy(lensSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensSummaries(LensSummary ... lensSummaries) {
            this.lensSummaries(Arrays.asList(lensSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensSummaries(Consumer<LensSummary.Builder> ... lensSummaries) {
            this.lensSummaries(Stream.of(lensSummaries).map(c -> (LensSummary)((LensSummary.Builder)LensSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLensesResponse build() {
            return new ListLensesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLensesResponse> {
        public Builder lensSummaries(Collection<LensSummary> var1);

        public Builder lensSummaries(LensSummary ... var1);

        public Builder lensSummaries(Consumer<LensSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

