/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.BestPractice;
import software.amazon.awssdk.services.wellarchitected.model.BestPracticesCopier;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuestionMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuestionMetric> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(QuestionMetric.getter(QuestionMetric::questionId)).setter(QuestionMetric.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Risk").getter(QuestionMetric.getter(QuestionMetric::riskAsString)).setter(QuestionMetric.setter(Builder::risk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()}).build();
    private static final SdkField<List<BestPractice>> BEST_PRACTICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BestPractices").getter(QuestionMetric.getter(QuestionMetric::bestPractices)).setter(QuestionMetric.setter(Builder::bestPractices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestPractices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BestPractice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, RISK_FIELD, BEST_PRACTICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QuestionId", QUESTION_ID_FIELD);
            this.put("Risk", RISK_FIELD);
            this.put("BestPractices", BEST_PRACTICES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String risk;
    private final List<BestPractice> bestPractices;

    private QuestionMetric(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.risk = builder.risk;
        this.bestPractices = builder.bestPractices;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final Risk risk() {
        return Risk.fromValue(this.risk);
    }

    public final String riskAsString() {
        return this.risk;
    }

    public final boolean hasBestPractices() {
        return this.bestPractices != null && !(this.bestPractices instanceof SdkAutoConstructList);
    }

    public final List<BestPractice> bestPractices() {
        return this.bestPractices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBestPractices() ? this.bestPractices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuestionMetric)) {
            return false;
        }
        QuestionMetric other = (QuestionMetric)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.riskAsString(), other.riskAsString()) && this.hasBestPractices() == other.hasBestPractices() && Objects.equals(this.bestPractices(), other.bestPractices());
    }

    public final String toString() {
        return ToString.builder((String)"QuestionMetric").add("QuestionId", (Object)this.questionId()).add("Risk", (Object)this.riskAsString()).add("BestPractices", this.hasBestPractices() ? this.bestPractices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "Risk": {
                return Optional.ofNullable(clazz.cast(this.riskAsString()));
            }
            case "BestPractices": {
                return Optional.ofNullable(clazz.cast(this.bestPractices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuestionMetric, T> g) {
        return obj -> g.apply((QuestionMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String risk;
        private List<BestPractice> bestPractices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuestionMetric model) {
            this.questionId(model.questionId);
            this.risk(model.risk);
            this.bestPractices(model.bestPractices);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getRisk() {
            return this.risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final List<BestPractice.Builder> getBestPractices() {
            List<BestPractice.Builder> result = BestPracticesCopier.copyToBuilder(this.bestPractices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBestPractices(Collection<BestPractice.BuilderImpl> bestPractices) {
            this.bestPractices = BestPracticesCopier.copyFromBuilder(bestPractices);
        }

        @Override
        public final Builder bestPractices(Collection<BestPractice> bestPractices) {
            this.bestPractices = BestPracticesCopier.copy(bestPractices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bestPractices(BestPractice ... bestPractices) {
            this.bestPractices(Arrays.asList(bestPractices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bestPractices(Consumer<BestPractice.Builder> ... bestPractices) {
            this.bestPractices(Stream.of(bestPractices).map(c -> (BestPractice)((BestPractice.Builder)BestPractice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public QuestionMetric build() {
            return new QuestionMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuestionMetric> {
        public Builder questionId(String var1);

        public Builder risk(String var1);

        public Builder risk(Risk var1);

        public Builder bestPractices(Collection<BestPractice> var1);

        public Builder bestPractices(BestPractice ... var1);

        public Builder bestPractices(Consumer<BestPractice.Builder> ... var1);
    }
}

