/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ReportFormat;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConsolidatedReportRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, GetConsolidatedReportRequest> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(GetConsolidatedReportRequest.getter(GetConsolidatedReportRequest::formatAsString)).setter(GetConsolidatedReportRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Format").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SHARED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeSharedResources").getter(GetConsolidatedReportRequest.getter(GetConsolidatedReportRequest::includeSharedResources)).setter(GetConsolidatedReportRequest.setter(Builder::includeSharedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeSharedResources").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetConsolidatedReportRequest.getter(GetConsolidatedReportRequest::nextToken)).setter(GetConsolidatedReportRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetConsolidatedReportRequest.getter(GetConsolidatedReportRequest::maxResults)).setter(GetConsolidatedReportRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, INCLUDE_SHARED_RESOURCES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Format", FORMAT_FIELD);
            this.put("IncludeSharedResources", INCLUDE_SHARED_RESOURCES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String format;
    private final Boolean includeSharedResources;
    private final String nextToken;
    private final Integer maxResults;

    private GetConsolidatedReportRequest(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.includeSharedResources = builder.includeSharedResources;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final ReportFormat format() {
        return ReportFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Boolean includeSharedResources() {
        return this.includeSharedResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSharedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsolidatedReportRequest)) {
            return false;
        }
        GetConsolidatedReportRequest other = (GetConsolidatedReportRequest)((Object)obj);
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.includeSharedResources(), other.includeSharedResources()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetConsolidatedReportRequest").add("Format", (Object)this.formatAsString()).add("IncludeSharedResources", (Object)this.includeSharedResources()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "IncludeSharedResources": {
                return Optional.ofNullable(clazz.cast(this.includeSharedResources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConsolidatedReportRequest, T> g) {
        return obj -> g.apply((GetConsolidatedReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String format;
        private Boolean includeSharedResources;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsolidatedReportRequest model) {
            super(model);
            this.format(model.format);
            this.includeSharedResources(model.includeSharedResources);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getIncludeSharedResources() {
            return this.includeSharedResources;
        }

        public final void setIncludeSharedResources(Boolean includeSharedResources) {
            this.includeSharedResources = includeSharedResources;
        }

        @Override
        public final Builder includeSharedResources(Boolean includeSharedResources) {
            this.includeSharedResources = includeSharedResources;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConsolidatedReportRequest build() {
            return new GetConsolidatedReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConsolidatedReportRequest> {
        public Builder format(String var1);

        public Builder format(ReportFormat var1);

        public Builder includeSharedResources(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

