/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.AccountJiraIssueManagementStatus;
import software.amazon.awssdk.services.wellarchitected.model.IntegrationStatusInput;
import software.amazon.awssdk.services.wellarchitected.model.IssueManagementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountJiraConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountJiraConfigurationInput> {
    private static final SdkField<String> ISSUE_MANAGEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssueManagementStatus").getter(AccountJiraConfigurationInput.getter(AccountJiraConfigurationInput::issueManagementStatusAsString)).setter(AccountJiraConfigurationInput.setter(Builder::issueManagementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementStatus").build()}).build();
    private static final SdkField<String> ISSUE_MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssueManagementType").getter(AccountJiraConfigurationInput.getter(AccountJiraConfigurationInput::issueManagementTypeAsString)).setter(AccountJiraConfigurationInput.setter(Builder::issueManagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementType").build()}).build();
    private static final SdkField<String> JIRA_PROJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JiraProjectKey").getter(AccountJiraConfigurationInput.getter(AccountJiraConfigurationInput::jiraProjectKey)).setter(AccountJiraConfigurationInput.setter(Builder::jiraProjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraProjectKey").build()}).build();
    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationStatus").getter(AccountJiraConfigurationInput.getter(AccountJiraConfigurationInput::integrationStatusAsString)).setter(AccountJiraConfigurationInput.setter(Builder::integrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUE_MANAGEMENT_STATUS_FIELD, ISSUE_MANAGEMENT_TYPE_FIELD, JIRA_PROJECT_KEY_FIELD, INTEGRATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IssueManagementStatus", ISSUE_MANAGEMENT_STATUS_FIELD);
            this.put("IssueManagementType", ISSUE_MANAGEMENT_TYPE_FIELD);
            this.put("JiraProjectKey", JIRA_PROJECT_KEY_FIELD);
            this.put("IntegrationStatus", INTEGRATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String issueManagementStatus;
    private final String issueManagementType;
    private final String jiraProjectKey;
    private final String integrationStatus;

    private AccountJiraConfigurationInput(BuilderImpl builder) {
        this.issueManagementStatus = builder.issueManagementStatus;
        this.issueManagementType = builder.issueManagementType;
        this.jiraProjectKey = builder.jiraProjectKey;
        this.integrationStatus = builder.integrationStatus;
    }

    public final AccountJiraIssueManagementStatus issueManagementStatus() {
        return AccountJiraIssueManagementStatus.fromValue(this.issueManagementStatus);
    }

    public final String issueManagementStatusAsString() {
        return this.issueManagementStatus;
    }

    public final IssueManagementType issueManagementType() {
        return IssueManagementType.fromValue(this.issueManagementType);
    }

    public final String issueManagementTypeAsString() {
        return this.issueManagementType;
    }

    public final String jiraProjectKey() {
        return this.jiraProjectKey;
    }

    public final IntegrationStatusInput integrationStatus() {
        return IntegrationStatusInput.fromValue(this.integrationStatus);
    }

    public final String integrationStatusAsString() {
        return this.integrationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issueManagementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraProjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountJiraConfigurationInput)) {
            return false;
        }
        AccountJiraConfigurationInput other = (AccountJiraConfigurationInput)obj;
        return Objects.equals(this.issueManagementStatusAsString(), other.issueManagementStatusAsString()) && Objects.equals(this.issueManagementTypeAsString(), other.issueManagementTypeAsString()) && Objects.equals(this.jiraProjectKey(), other.jiraProjectKey()) && Objects.equals(this.integrationStatusAsString(), other.integrationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccountJiraConfigurationInput").add("IssueManagementStatus", (Object)this.issueManagementStatusAsString()).add("IssueManagementType", (Object)this.issueManagementTypeAsString()).add("JiraProjectKey", (Object)this.jiraProjectKey()).add("IntegrationStatus", (Object)this.integrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IssueManagementStatus": {
                return Optional.ofNullable(clazz.cast(this.issueManagementStatusAsString()));
            }
            case "IssueManagementType": {
                return Optional.ofNullable(clazz.cast(this.issueManagementTypeAsString()));
            }
            case "JiraProjectKey": {
                return Optional.ofNullable(clazz.cast(this.jiraProjectKey()));
            }
            case "IntegrationStatus": {
                return Optional.ofNullable(clazz.cast(this.integrationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountJiraConfigurationInput, T> g) {
        return obj -> g.apply((AccountJiraConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issueManagementStatus;
        private String issueManagementType;
        private String jiraProjectKey;
        private String integrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountJiraConfigurationInput model) {
            this.issueManagementStatus(model.issueManagementStatus);
            this.issueManagementType(model.issueManagementType);
            this.jiraProjectKey(model.jiraProjectKey);
            this.integrationStatus(model.integrationStatus);
        }

        public final String getIssueManagementStatus() {
            return this.issueManagementStatus;
        }

        public final void setIssueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
        }

        @Override
        public final Builder issueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
            return this;
        }

        @Override
        public final Builder issueManagementStatus(AccountJiraIssueManagementStatus issueManagementStatus) {
            this.issueManagementStatus(issueManagementStatus == null ? null : issueManagementStatus.toString());
            return this;
        }

        public final String getIssueManagementType() {
            return this.issueManagementType;
        }

        public final void setIssueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
        }

        @Override
        public final Builder issueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
            return this;
        }

        @Override
        public final Builder issueManagementType(IssueManagementType issueManagementType) {
            this.issueManagementType(issueManagementType == null ? null : issueManagementType.toString());
            return this;
        }

        public final String getJiraProjectKey() {
            return this.jiraProjectKey;
        }

        public final void setJiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
        }

        @Override
        public final Builder jiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
            return this;
        }

        public final String getIntegrationStatus() {
            return this.integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatusInput integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        public AccountJiraConfigurationInput build() {
            return new AccountJiraConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountJiraConfigurationInput> {
        public Builder issueManagementStatus(String var1);

        public Builder issueManagementStatus(AccountJiraIssueManagementStatus var1);

        public Builder issueManagementType(String var1);

        public Builder issueManagementType(IssueManagementType var1);

        public Builder jiraProjectKey(String var1);

        public Builder integrationStatus(String var1);

        public Builder integrationStatus(IntegrationStatusInput var1);
    }
}

