/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChoiceStatus {
    SELECTED("SELECTED"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    UNSELECTED("UNSELECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChoiceStatus> VALUE_MAP;
    private final String value;

    private ChoiceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChoiceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChoiceStatus> knownValues() {
        EnumSet<ChoiceStatus> knownValues = EnumSet.allOf(ChoiceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChoiceStatus.class, ChoiceStatus::toString);
    }
}

