/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ProfileArnsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateProfilesRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, AssociateProfilesRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(AssociateProfilesRequest.getter(AssociateProfilesRequest::workloadId)).setter(AssociateProfilesRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<List<String>> PROFILE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileArns").getter(AssociateProfilesRequest.getter(AssociateProfilesRequest::profileArns)).setter(AssociateProfilesRequest.setter(Builder::profileArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, PROFILE_ARNS_FIELD));
    private final String workloadId;
    private final List<String> profileArns;

    private AssociateProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.profileArns = builder.profileArns;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final boolean hasProfileArns() {
        return this.profileArns != null && !(this.profileArns instanceof SdkAutoConstructList);
    }

    public final List<String> profileArns() {
        return this.profileArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileArns() ? this.profileArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateProfilesRequest)) {
            return false;
        }
        AssociateProfilesRequest other = (AssociateProfilesRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && this.hasProfileArns() == other.hasProfileArns() && Objects.equals(this.profileArns(), other.profileArns());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateProfilesRequest").add("WorkloadId", (Object)this.workloadId()).add("ProfileArns", this.hasProfileArns() ? this.profileArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "ProfileArns": {
                return Optional.ofNullable(clazz.cast(this.profileArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateProfilesRequest, T> g) {
        return obj -> g.apply((AssociateProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private List<String> profileArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateProfilesRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.profileArns(model.profileArns);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Collection<String> getProfileArns() {
            if (this.profileArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profileArns;
        }

        public final void setProfileArns(Collection<String> profileArns) {
            this.profileArns = ProfileArnsCopier.copy(profileArns);
        }

        @Override
        public final Builder profileArns(Collection<String> profileArns) {
            this.profileArns = ProfileArnsCopier.copy(profileArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileArns(String ... profileArns) {
            this.profileArns(Arrays.asList(profileArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateProfilesRequest build() {
            return new AssociateProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateProfilesRequest> {
        public Builder workloadId(String var1);

        public Builder profileArns(Collection<String> var1);

        public Builder profileArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

