/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IntegrationStatusInput {
    NOT_CONFIGURED("NOT_CONFIGURED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IntegrationStatusInput> VALUE_MAP;
    private final String value;

    private IntegrationStatusInput(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegrationStatusInput fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegrationStatusInput> knownValues() {
        EnumSet<IntegrationStatusInput> knownValues = EnumSet.allOf(IntegrationStatusInput.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IntegrationStatusInput.class, IntegrationStatusInput::toString);
    }
}

