/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IntegratingService {
    JIRA("JIRA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IntegratingService> VALUE_MAP;
    private final String value;

    private IntegratingService(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegratingService fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegratingService> knownValues() {
        EnumSet<IntegratingService> knownValues = EnumSet.allOf(IntegratingService.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IntegratingService.class, IntegratingService::toString);
    }
}

