/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.CheckSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.CheckSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCheckSummariesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListCheckSummariesResponse> {
    private static final SdkField<List<CheckSummary>> CHECK_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckSummaries").getter(ListCheckSummariesResponse.getter(ListCheckSummariesResponse::checkSummaries)).setter(ListCheckSummariesResponse.setter(Builder::checkSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CheckSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCheckSummariesResponse.getter(ListCheckSummariesResponse::nextToken)).setter(ListCheckSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CheckSummary> checkSummaries;
    private final String nextToken;

    private ListCheckSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.checkSummaries = builder.checkSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCheckSummaries() {
        return this.checkSummaries != null && !(this.checkSummaries instanceof SdkAutoConstructList);
    }

    public final List<CheckSummary> checkSummaries() {
        return this.checkSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckSummaries() ? this.checkSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCheckSummariesResponse)) {
            return false;
        }
        ListCheckSummariesResponse other = (ListCheckSummariesResponse)((Object)obj);
        return this.hasCheckSummaries() == other.hasCheckSummaries() && Objects.equals(this.checkSummaries(), other.checkSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCheckSummariesResponse").add("CheckSummaries", this.hasCheckSummaries() ? this.checkSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckSummaries": {
                return Optional.ofNullable(clazz.cast(this.checkSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCheckSummariesResponse, T> g) {
        return obj -> g.apply((ListCheckSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<CheckSummary> checkSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCheckSummariesResponse model) {
            super(model);
            this.checkSummaries(model.checkSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<CheckSummary.Builder> getCheckSummaries() {
            List<CheckSummary.Builder> result = CheckSummariesCopier.copyToBuilder(this.checkSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckSummaries(Collection<CheckSummary.BuilderImpl> checkSummaries) {
            this.checkSummaries = CheckSummariesCopier.copyFromBuilder(checkSummaries);
        }

        @Override
        public final Builder checkSummaries(Collection<CheckSummary> checkSummaries) {
            this.checkSummaries = CheckSummariesCopier.copy(checkSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkSummaries(CheckSummary ... checkSummaries) {
            this.checkSummaries(Arrays.asList(checkSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkSummaries(Consumer<CheckSummary.Builder> ... checkSummaries) {
            this.checkSummaries(Stream.of(checkSummaries).map(c -> (CheckSummary)((CheckSummary.Builder)CheckSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCheckSummariesResponse build() {
            return new ListCheckSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCheckSummariesResponse> {
        public Builder checkSummaries(Collection<CheckSummary> var1);

        public Builder checkSummaries(CheckSummary ... var1);

        public Builder checkSummaries(Consumer<CheckSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

