/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestion;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Profile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Profile> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(Profile.getter(Profile::profileArn)).setter(Profile.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileVersion").getter(Profile.getter(Profile::profileVersion)).setter(Profile.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileVersion").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(Profile.getter(Profile::profileName)).setter(Profile.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<String> PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileDescription").getter(Profile.getter(Profile::profileDescription)).setter(Profile.setter(Builder::profileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileDescription").build()}).build();
    private static final SdkField<List<ProfileQuestion>> PROFILE_QUESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileQuestions").getter(Profile.getter(Profile::profileQuestions)).setter(Profile.setter(Builder::profileQuestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileQuestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileQuestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(Profile.getter(Profile::owner)).setter(Profile.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Profile.getter(Profile::createdAt)).setter(Profile.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Profile.getter(Profile::updatedAt)).setter(Profile.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareInvitationId").getter(Profile.getter(Profile::shareInvitationId)).setter(Profile.setter(Builder::shareInvitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Profile.getter(Profile::tags)).setter(Profile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD, PROFILE_VERSION_FIELD, PROFILE_NAME_FIELD, PROFILE_DESCRIPTION_FIELD, PROFILE_QUESTIONS_FIELD, OWNER_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, SHARE_INVITATION_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileArn;
    private final String profileVersion;
    private final String profileName;
    private final String profileDescription;
    private final List<ProfileQuestion> profileQuestions;
    private final String owner;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String shareInvitationId;
    private final Map<String, String> tags;

    private Profile(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileVersion = builder.profileVersion;
        this.profileName = builder.profileName;
        this.profileDescription = builder.profileDescription;
        this.profileQuestions = builder.profileQuestions;
        this.owner = builder.owner;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.shareInvitationId = builder.shareInvitationId;
        this.tags = builder.tags;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileDescription() {
        return this.profileDescription;
    }

    public final boolean hasProfileQuestions() {
        return this.profileQuestions != null && !(this.profileQuestions instanceof SdkAutoConstructList);
    }

    public final List<ProfileQuestion> profileQuestions() {
        return this.profileQuestions;
    }

    public final String owner() {
        return this.owner;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String shareInvitationId() {
        return this.shareInvitationId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileQuestions() ? this.profileQuestions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)obj;
        return Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileDescription(), other.profileDescription()) && this.hasProfileQuestions() == other.hasProfileQuestions() && Objects.equals(this.profileQuestions(), other.profileQuestions()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.shareInvitationId(), other.shareInvitationId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Profile").add("ProfileArn", (Object)this.profileArn()).add("ProfileVersion", (Object)this.profileVersion()).add("ProfileName", (Object)this.profileName()).add("ProfileDescription", (Object)this.profileDescription()).add("ProfileQuestions", this.hasProfileQuestions() ? this.profileQuestions() : null).add("Owner", (Object)this.owner()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ShareInvitationId", (Object)this.shareInvitationId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "ProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.profileDescription()));
            }
            case "ProfileQuestions": {
                return Optional.ofNullable(clazz.cast(this.profileQuestions()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "ShareInvitationId": {
                return Optional.ofNullable(clazz.cast(this.shareInvitationId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileArn;
        private String profileVersion;
        private String profileName;
        private String profileDescription;
        private List<ProfileQuestion> profileQuestions = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private Instant createdAt;
        private Instant updatedAt;
        private String shareInvitationId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            this.profileArn(model.profileArn);
            this.profileVersion(model.profileVersion);
            this.profileName(model.profileName);
            this.profileDescription(model.profileDescription);
            this.profileQuestions(model.profileQuestions);
            this.owner(model.owner);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.shareInvitationId(model.shareInvitationId);
            this.tags(model.tags);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileDescription() {
            return this.profileDescription;
        }

        public final void setProfileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
        }

        @Override
        public final Builder profileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
            return this;
        }

        public final List<ProfileQuestion.Builder> getProfileQuestions() {
            List<ProfileQuestion.Builder> result = ProfileQuestionsCopier.copyToBuilder(this.profileQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileQuestions(Collection<ProfileQuestion.BuilderImpl> profileQuestions) {
            this.profileQuestions = ProfileQuestionsCopier.copyFromBuilder(profileQuestions);
        }

        @Override
        public final Builder profileQuestions(Collection<ProfileQuestion> profileQuestions) {
            this.profileQuestions = ProfileQuestionsCopier.copy(profileQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(ProfileQuestion ... profileQuestions) {
            this.profileQuestions(Arrays.asList(profileQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(Consumer<ProfileQuestion.Builder> ... profileQuestions) {
            this.profileQuestions(Stream.of(profileQuestions).map(c -> (ProfileQuestion)((ProfileQuestion.Builder)ProfileQuestion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getShareInvitationId() {
            return this.shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Profile build() {
            return new Profile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Profile> {
        public Builder profileArn(String var1);

        public Builder profileVersion(String var1);

        public Builder profileName(String var1);

        public Builder profileDescription(String var1);

        public Builder profileQuestions(Collection<ProfileQuestion> var1);

        public Builder profileQuestions(ProfileQuestion ... var1);

        public Builder profileQuestions(Consumer<ProfileQuestion.Builder> ... var1);

        public Builder owner(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder shareInvitationId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

