/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse;

public class ListTemplateSharesPublisher
implements SdkPublisher<ListTemplateSharesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListTemplateSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateSharesPublisher(WellArchitectedAsyncClient client, ListTemplateSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateSharesPublisher(WellArchitectedAsyncClient client, ListTemplateSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTemplateSharesResponseFetcher
    implements AsyncPageFetcher<ListTemplateSharesResponse> {
        private ListTemplateSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateSharesResponse> nextPage(ListTemplateSharesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateSharesPublisher.this.client.listTemplateShares(ListTemplateSharesPublisher.this.firstRequest);
            }
            return ListTemplateSharesPublisher.this.client.listTemplateShares((ListTemplateSharesRequest)((Object)ListTemplateSharesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

