/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse;

public class ListProfileNotificationsPublisher
implements SdkPublisher<ListProfileNotificationsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListProfileNotificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfileNotificationsPublisher(WellArchitectedAsyncClient client, ListProfileNotificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfileNotificationsPublisher(WellArchitectedAsyncClient client, ListProfileNotificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfileNotificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfileNotificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProfileNotificationsResponseFetcher
    implements AsyncPageFetcher<ListProfileNotificationsResponse> {
        private ListProfileNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfileNotificationsResponse> nextPage(ListProfileNotificationsResponse previousPage) {
            if (previousPage == null) {
                return ListProfileNotificationsPublisher.this.client.listProfileNotifications(ListProfileNotificationsPublisher.this.firstRequest);
            }
            return ListProfileNotificationsPublisher.this.client.listProfileNotifications((ListProfileNotificationsRequest)((Object)ListProfileNotificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

