/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse;

public class ListShareInvitationsIterable
implements SdkIterable<ListShareInvitationsResponse> {
    private final WellArchitectedClient client;
    private final ListShareInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListShareInvitationsIterable(WellArchitectedClient client, ListShareInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListShareInvitationsResponseFetcher();
    }

    public Iterator<ListShareInvitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListShareInvitationsResponseFetcher
    implements SyncPageFetcher<ListShareInvitationsResponse> {
        private ListShareInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListShareInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListShareInvitationsResponse nextPage(ListShareInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListShareInvitationsIterable.this.client.listShareInvitations(ListShareInvitationsIterable.this.firstRequest);
            }
            return ListShareInvitationsIterable.this.client.listShareInvitations((ListShareInvitationsRequest)((Object)ListShareInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

