/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLensVersionDifferenceRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, GetLensVersionDifferenceRequest> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(GetLensVersionDifferenceRequest.getter(GetLensVersionDifferenceRequest::lensAlias)).setter(GetLensVersionDifferenceRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> BASE_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseLensVersion").getter(GetLensVersionDifferenceRequest.getter(GetLensVersionDifferenceRequest::baseLensVersion)).setter(GetLensVersionDifferenceRequest.setter(Builder::baseLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("BaseLensVersion").build()}).build();
    private static final SdkField<String> TARGET_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLensVersion").getter(GetLensVersionDifferenceRequest.getter(GetLensVersionDifferenceRequest::targetLensVersion)).setter(GetLensVersionDifferenceRequest.setter(Builder::targetLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TargetLensVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, BASE_LENS_VERSION_FIELD, TARGET_LENS_VERSION_FIELD));
    private final String lensAlias;
    private final String baseLensVersion;
    private final String targetLensVersion;

    private GetLensVersionDifferenceRequest(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.baseLensVersion = builder.baseLensVersion;
        this.targetLensVersion = builder.targetLensVersion;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String baseLensVersion() {
        return this.baseLensVersion;
    }

    public final String targetLensVersion() {
        return this.targetLensVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLensVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensVersionDifferenceRequest)) {
            return false;
        }
        GetLensVersionDifferenceRequest other = (GetLensVersionDifferenceRequest)((Object)obj);
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.baseLensVersion(), other.baseLensVersion()) && Objects.equals(this.targetLensVersion(), other.targetLensVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetLensVersionDifferenceRequest").add("LensAlias", (Object)this.lensAlias()).add("BaseLensVersion", (Object)this.baseLensVersion()).add("TargetLensVersion", (Object)this.targetLensVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "BaseLensVersion": {
                return Optional.ofNullable(clazz.cast(this.baseLensVersion()));
            }
            case "TargetLensVersion": {
                return Optional.ofNullable(clazz.cast(this.targetLensVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLensVersionDifferenceRequest, T> g) {
        return obj -> g.apply((GetLensVersionDifferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String lensAlias;
        private String baseLensVersion;
        private String targetLensVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensVersionDifferenceRequest model) {
            super(model);
            this.lensAlias(model.lensAlias);
            this.baseLensVersion(model.baseLensVersion);
            this.targetLensVersion(model.targetLensVersion);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        @Transient
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getBaseLensVersion() {
            return this.baseLensVersion;
        }

        public final void setBaseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
        }

        @Override
        @Transient
        public final Builder baseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
            return this;
        }

        public final String getTargetLensVersion() {
            return this.targetLensVersion;
        }

        public final void setTargetLensVersion(String targetLensVersion) {
            this.targetLensVersion = targetLensVersion;
        }

        @Override
        @Transient
        public final Builder targetLensVersion(String targetLensVersion) {
            this.targetLensVersion = targetLensVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLensVersionDifferenceRequest build() {
            return new GetLensVersionDifferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLensVersionDifferenceRequest> {
        public Builder lensAlias(String var1);

        public Builder baseLensVersion(String var1);

        public Builder targetLensVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

