/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.DifferenceStatus;
import software.amazon.awssdk.services.wellarchitected.model.QuestionDifference;
import software.amazon.awssdk.services.wellarchitected.model.QuestionDifferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PillarDifference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PillarDifference> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(PillarDifference.getter(PillarDifference::pillarId)).setter(PillarDifference.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> PILLAR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarName").getter(PillarDifference.getter(PillarDifference::pillarName)).setter(PillarDifference.setter(Builder::pillarName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarName").build()}).build();
    private static final SdkField<String> DIFFERENCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DifferenceStatus").getter(PillarDifference.getter(PillarDifference::differenceStatusAsString)).setter(PillarDifference.setter(Builder::differenceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DifferenceStatus").build()}).build();
    private static final SdkField<List<QuestionDifference>> QUESTION_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuestionDifferences").getter(PillarDifference.getter(PillarDifference::questionDifferences)).setter(PillarDifference.setter(Builder::questionDifferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDifferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuestionDifference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD, PILLAR_NAME_FIELD, DIFFERENCE_STATUS_FIELD, QUESTION_DIFFERENCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pillarId;
    private final String pillarName;
    private final String differenceStatus;
    private final List<QuestionDifference> questionDifferences;

    private PillarDifference(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.pillarName = builder.pillarName;
        this.differenceStatus = builder.differenceStatus;
        this.questionDifferences = builder.questionDifferences;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String pillarName() {
        return this.pillarName;
    }

    public final DifferenceStatus differenceStatus() {
        return DifferenceStatus.fromValue(this.differenceStatus);
    }

    public final String differenceStatusAsString() {
        return this.differenceStatus;
    }

    public final boolean hasQuestionDifferences() {
        return this.questionDifferences != null && !(this.questionDifferences instanceof SdkAutoConstructList);
    }

    public final List<QuestionDifference> questionDifferences() {
        return this.questionDifferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarName());
        hashCode = 31 * hashCode + Objects.hashCode(this.differenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuestionDifferences() ? this.questionDifferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarDifference)) {
            return false;
        }
        PillarDifference other = (PillarDifference)obj;
        return Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.pillarName(), other.pillarName()) && Objects.equals(this.differenceStatusAsString(), other.differenceStatusAsString()) && this.hasQuestionDifferences() == other.hasQuestionDifferences() && Objects.equals(this.questionDifferences(), other.questionDifferences());
    }

    public final String toString() {
        return ToString.builder((String)"PillarDifference").add("PillarId", (Object)this.pillarId()).add("PillarName", (Object)this.pillarName()).add("DifferenceStatus", (Object)this.differenceStatusAsString()).add("QuestionDifferences", this.hasQuestionDifferences() ? this.questionDifferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "PillarName": {
                return Optional.ofNullable(clazz.cast(this.pillarName()));
            }
            case "DifferenceStatus": {
                return Optional.ofNullable(clazz.cast(this.differenceStatusAsString()));
            }
            case "QuestionDifferences": {
                return Optional.ofNullable(clazz.cast(this.questionDifferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PillarDifference, T> g) {
        return obj -> g.apply((PillarDifference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pillarId;
        private String pillarName;
        private String differenceStatus;
        private List<QuestionDifference> questionDifferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PillarDifference model) {
            this.pillarId(model.pillarId);
            this.pillarName(model.pillarName);
            this.differenceStatus(model.differenceStatus);
            this.questionDifferences(model.questionDifferences);
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        @Transient
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getPillarName() {
            return this.pillarName;
        }

        public final void setPillarName(String pillarName) {
            this.pillarName = pillarName;
        }

        @Override
        @Transient
        public final Builder pillarName(String pillarName) {
            this.pillarName = pillarName;
            return this;
        }

        public final String getDifferenceStatus() {
            return this.differenceStatus;
        }

        public final void setDifferenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
        }

        @Override
        @Transient
        public final Builder differenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder differenceStatus(DifferenceStatus differenceStatus) {
            this.differenceStatus(differenceStatus == null ? null : differenceStatus.toString());
            return this;
        }

        public final List<QuestionDifference.Builder> getQuestionDifferences() {
            List<QuestionDifference.Builder> result = QuestionDifferencesCopier.copyToBuilder(this.questionDifferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuestionDifferences(Collection<QuestionDifference.BuilderImpl> questionDifferences) {
            this.questionDifferences = QuestionDifferencesCopier.copyFromBuilder(questionDifferences);
        }

        @Override
        @Transient
        public final Builder questionDifferences(Collection<QuestionDifference> questionDifferences) {
            this.questionDifferences = QuestionDifferencesCopier.copy(questionDifferences);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder questionDifferences(QuestionDifference ... questionDifferences) {
            this.questionDifferences(Arrays.asList(questionDifferences));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder questionDifferences(Consumer<QuestionDifference.Builder> ... questionDifferences) {
            this.questionDifferences(Stream.of(questionDifferences).map(c -> (QuestionDifference)((QuestionDifference.Builder)QuestionDifference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PillarDifference build() {
            return new PillarDifference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PillarDifference> {
        public Builder pillarId(String var1);

        public Builder pillarName(String var1);

        public Builder differenceStatus(String var1);

        public Builder differenceStatus(DifferenceStatus var1);

        public Builder questionDifferences(Collection<QuestionDifference> var1);

        public Builder questionDifferences(QuestionDifference ... var1);

        public Builder questionDifferences(Consumer<QuestionDifference.Builder> ... var1);
    }
}

