/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.PermissionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareInvitationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareInvitationSummary> {
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareInvitationId").getter(ShareInvitationSummary.getter(ShareInvitationSummary::shareInvitationId)).setter(ShareInvitationSummary.setter(Builder::shareInvitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()}).build();
    private static final SdkField<String> SHARED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedBy").getter(ShareInvitationSummary.getter(ShareInvitationSummary::sharedBy)).setter(ShareInvitationSummary.setter(Builder::sharedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedBy").build()}).build();
    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedWith").getter(ShareInvitationSummary.getter(ShareInvitationSummary::sharedWith)).setter(ShareInvitationSummary.setter(Builder::sharedWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionType").getter(ShareInvitationSummary.getter(ShareInvitationSummary::permissionTypeAsString)).setter(ShareInvitationSummary.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(ShareInvitationSummary.getter(ShareInvitationSummary::workloadName)).setter(ShareInvitationSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ShareInvitationSummary.getter(ShareInvitationSummary::workloadId)).setter(ShareInvitationSummary.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_INVITATION_ID_FIELD, SHARED_BY_FIELD, SHARED_WITH_FIELD, PERMISSION_TYPE_FIELD, WORKLOAD_NAME_FIELD, WORKLOAD_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shareInvitationId;
    private final String sharedBy;
    private final String sharedWith;
    private final String permissionType;
    private final String workloadName;
    private final String workloadId;

    private ShareInvitationSummary(BuilderImpl builder) {
        this.shareInvitationId = builder.shareInvitationId;
        this.sharedBy = builder.sharedBy;
        this.sharedWith = builder.sharedWith;
        this.permissionType = builder.permissionType;
        this.workloadName = builder.workloadName;
        this.workloadId = builder.workloadId;
    }

    public final String shareInvitationId() {
        return this.shareInvitationId;
    }

    public final String sharedBy() {
        return this.sharedBy;
    }

    public final String sharedWith() {
        return this.sharedWith;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareInvitationSummary)) {
            return false;
        }
        ShareInvitationSummary other = (ShareInvitationSummary)obj;
        return Objects.equals(this.shareInvitationId(), other.shareInvitationId()) && Objects.equals(this.sharedBy(), other.sharedBy()) && Objects.equals(this.sharedWith(), other.sharedWith()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.workloadId(), other.workloadId());
    }

    public final String toString() {
        return ToString.builder((String)"ShareInvitationSummary").add("ShareInvitationId", (Object)this.shareInvitationId()).add("SharedBy", (Object)this.sharedBy()).add("SharedWith", (Object)this.sharedWith()).add("PermissionType", (Object)this.permissionTypeAsString()).add("WorkloadName", (Object)this.workloadName()).add("WorkloadId", (Object)this.workloadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareInvitationId": {
                return Optional.ofNullable(clazz.cast(this.shareInvitationId()));
            }
            case "SharedBy": {
                return Optional.ofNullable(clazz.cast(this.sharedBy()));
            }
            case "SharedWith": {
                return Optional.ofNullable(clazz.cast(this.sharedWith()));
            }
            case "PermissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareInvitationSummary, T> g) {
        return obj -> g.apply((ShareInvitationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shareInvitationId;
        private String sharedBy;
        private String sharedWith;
        private String permissionType;
        private String workloadName;
        private String workloadId;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareInvitationSummary model) {
            this.shareInvitationId(model.shareInvitationId);
            this.sharedBy(model.sharedBy);
            this.sharedWith(model.sharedWith);
            this.permissionType(model.permissionType);
            this.workloadName(model.workloadName);
            this.workloadId(model.workloadId);
        }

        public final String getShareInvitationId() {
            return this.shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        public final String getSharedBy() {
            return this.sharedBy;
        }

        @Override
        public final Builder sharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
            return this;
        }

        public final void setSharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
        }

        public final String getSharedWith() {
            return this.sharedWith;
        }

        @Override
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public ShareInvitationSummary build() {
            return new ShareInvitationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareInvitationSummary> {
        public Builder shareInvitationId(String var1);

        public Builder sharedBy(String var1);

        public Builder sharedWith(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder workloadName(String var1);

        public Builder workloadId(String var1);
    }
}

