/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Risk {
    UNANSWERED("UNANSWERED"),
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    NONE("NONE"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Risk(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Risk fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Risk.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Risk> knownValues() {
        return Stream.of(Risk.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

