/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadAccountIdsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadAwsRegionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadEnvironment;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadImprovementStatus;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadNonAwsRegionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadPillarPrioritiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkloadRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateWorkloadRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::workloadId)).setter(UpdateWorkloadRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::workloadName)).setter(UpdateWorkloadRequest.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::description)).setter(UpdateWorkloadRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Environment").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::environmentAsString)).setter(UpdateWorkloadRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::accountIds)).setter(UpdateWorkloadRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsRegions").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::awsRegions)).setter(UpdateWorkloadRequest.setter(Builder::awsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NON_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonAwsRegions").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::nonAwsRegions)).setter(UpdateWorkloadRequest.setter(Builder::nonAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PILLAR_PRIORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PillarPriorities").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::pillarPriorities)).setter(UpdateWorkloadRequest.setter(Builder::pillarPriorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarPriorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARCHITECTURAL_DESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchitecturalDesign").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::architecturalDesign)).setter(UpdateWorkloadRequest.setter(Builder::architecturalDesign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitecturalDesign").build()}).build();
    private static final SdkField<String> REVIEW_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewOwner").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::reviewOwner)).setter(UpdateWorkloadRequest.setter(Builder::reviewOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewOwner").build()}).build();
    private static final SdkField<Boolean> IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsReviewOwnerUpdateAcknowledged").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::isReviewOwnerUpdateAcknowledged)).setter(UpdateWorkloadRequest.setter(Builder::isReviewOwnerUpdateAcknowledged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReviewOwnerUpdateAcknowledged").build()}).build();
    private static final SdkField<String> INDUSTRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndustryType").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::industryType)).setter(UpdateWorkloadRequest.setter(Builder::industryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustryType").build()}).build();
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::industry)).setter(UpdateWorkloadRequest.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::notes)).setter(UpdateWorkloadRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> IMPROVEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImprovementStatus").getter(UpdateWorkloadRequest.getter(UpdateWorkloadRequest::improvementStatusAsString)).setter(UpdateWorkloadRequest.setter(Builder::improvementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_FIELD, ACCOUNT_IDS_FIELD, AWS_REGIONS_FIELD, NON_AWS_REGIONS_FIELD, PILLAR_PRIORITIES_FIELD, ARCHITECTURAL_DESIGN_FIELD, REVIEW_OWNER_FIELD, IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD, INDUSTRY_TYPE_FIELD, INDUSTRY_FIELD, NOTES_FIELD, IMPROVEMENT_STATUS_FIELD));
    private final String workloadId;
    private final String workloadName;
    private final String description;
    private final String environment;
    private final List<String> accountIds;
    private final List<String> awsRegions;
    private final List<String> nonAwsRegions;
    private final List<String> pillarPriorities;
    private final String architecturalDesign;
    private final String reviewOwner;
    private final Boolean isReviewOwnerUpdateAcknowledged;
    private final String industryType;
    private final String industry;
    private final String notes;
    private final String improvementStatus;

    private UpdateWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.description = builder.description;
        this.environment = builder.environment;
        this.accountIds = builder.accountIds;
        this.awsRegions = builder.awsRegions;
        this.nonAwsRegions = builder.nonAwsRegions;
        this.pillarPriorities = builder.pillarPriorities;
        this.architecturalDesign = builder.architecturalDesign;
        this.reviewOwner = builder.reviewOwner;
        this.isReviewOwnerUpdateAcknowledged = builder.isReviewOwnerUpdateAcknowledged;
        this.industryType = builder.industryType;
        this.industry = builder.industry;
        this.notes = builder.notes;
        this.improvementStatus = builder.improvementStatus;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String description() {
        return this.description;
    }

    public final WorkloadEnvironment environment() {
        return WorkloadEnvironment.fromValue(this.environment);
    }

    public final String environmentAsString() {
        return this.environment;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasAwsRegions() {
        return this.awsRegions != null && !(this.awsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> awsRegions() {
        return this.awsRegions;
    }

    public final boolean hasNonAwsRegions() {
        return this.nonAwsRegions != null && !(this.nonAwsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> nonAwsRegions() {
        return this.nonAwsRegions;
    }

    public final boolean hasPillarPriorities() {
        return this.pillarPriorities != null && !(this.pillarPriorities instanceof SdkAutoConstructList);
    }

    public final List<String> pillarPriorities() {
        return this.pillarPriorities;
    }

    public final String architecturalDesign() {
        return this.architecturalDesign;
    }

    public final String reviewOwner() {
        return this.reviewOwner;
    }

    public final Boolean isReviewOwnerUpdateAcknowledged() {
        return this.isReviewOwnerUpdateAcknowledged;
    }

    public final String industryType() {
        return this.industryType;
    }

    public final String industry() {
        return this.industry;
    }

    public final String notes() {
        return this.notes;
    }

    public final WorkloadImprovementStatus improvementStatus() {
        return WorkloadImprovementStatus.fromValue(this.improvementStatus);
    }

    public final String improvementStatusAsString() {
        return this.improvementStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsRegions() ? this.awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonAwsRegions() ? this.nonAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarPriorities() ? this.pillarPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.architecturalDesign());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.isReviewOwnerUpdateAcknowledged());
        hashCode = 31 * hashCode + Objects.hashCode(this.industryType());
        hashCode = 31 * hashCode + Objects.hashCode(this.industry());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadRequest)) {
            return false;
        }
        UpdateWorkloadRequest other = (UpdateWorkloadRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentAsString(), other.environmentAsString()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasAwsRegions() == other.hasAwsRegions() && Objects.equals(this.awsRegions(), other.awsRegions()) && this.hasNonAwsRegions() == other.hasNonAwsRegions() && Objects.equals(this.nonAwsRegions(), other.nonAwsRegions()) && this.hasPillarPriorities() == other.hasPillarPriorities() && Objects.equals(this.pillarPriorities(), other.pillarPriorities()) && Objects.equals(this.architecturalDesign(), other.architecturalDesign()) && Objects.equals(this.reviewOwner(), other.reviewOwner()) && Objects.equals(this.isReviewOwnerUpdateAcknowledged(), other.isReviewOwnerUpdateAcknowledged()) && Objects.equals(this.industryType(), other.industryType()) && Objects.equals(this.industry(), other.industry()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.improvementStatusAsString(), other.improvementStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkloadRequest").add("WorkloadId", (Object)this.workloadId()).add("WorkloadName", (Object)this.workloadName()).add("Description", (Object)this.description()).add("Environment", (Object)this.environmentAsString()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AwsRegions", this.hasAwsRegions() ? this.awsRegions() : null).add("NonAwsRegions", this.hasNonAwsRegions() ? this.nonAwsRegions() : null).add("PillarPriorities", this.hasPillarPriorities() ? this.pillarPriorities() : null).add("ArchitecturalDesign", (Object)this.architecturalDesign()).add("ReviewOwner", (Object)this.reviewOwner()).add("IsReviewOwnerUpdateAcknowledged", (Object)this.isReviewOwnerUpdateAcknowledged()).add("IndustryType", (Object)this.industryType()).add("Industry", (Object)this.industry()).add("Notes", (Object)this.notes()).add("ImprovementStatus", (Object)this.improvementStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environmentAsString()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
            case "NonAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.nonAwsRegions()));
            }
            case "PillarPriorities": {
                return Optional.ofNullable(clazz.cast(this.pillarPriorities()));
            }
            case "ArchitecturalDesign": {
                return Optional.ofNullable(clazz.cast(this.architecturalDesign()));
            }
            case "ReviewOwner": {
                return Optional.ofNullable(clazz.cast(this.reviewOwner()));
            }
            case "IsReviewOwnerUpdateAcknowledged": {
                return Optional.ofNullable(clazz.cast(this.isReviewOwnerUpdateAcknowledged()));
            }
            case "IndustryType": {
                return Optional.ofNullable(clazz.cast(this.industryType()));
            }
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industry()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "ImprovementStatus": {
                return Optional.ofNullable(clazz.cast(this.improvementStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadRequest, T> g) {
        return obj -> g.apply((UpdateWorkloadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String workloadName;
        private String description;
        private String environment;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> nonAwsRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> pillarPriorities = DefaultSdkAutoConstructList.getInstance();
        private String architecturalDesign;
        private String reviewOwner;
        private Boolean isReviewOwnerUpdateAcknowledged;
        private String industryType;
        private String industry;
        private String notes;
        private String improvementStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.workloadName(model.workloadName);
            this.description(model.description);
            this.environment(model.environment);
            this.accountIds(model.accountIds);
            this.awsRegions(model.awsRegions);
            this.nonAwsRegions(model.nonAwsRegions);
            this.pillarPriorities(model.pillarPriorities);
            this.architecturalDesign(model.architecturalDesign);
            this.reviewOwner(model.reviewOwner);
            this.isReviewOwnerUpdateAcknowledged(model.isReviewOwnerUpdateAcknowledged);
            this.industryType(model.industryType);
            this.industry(model.industry);
            this.notes(model.notes);
            this.improvementStatus(model.improvementStatus);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public final Builder environment(WorkloadEnvironment environment) {
            this.environment(environment == null ? null : environment.toString());
            return this;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
        }

        public final Collection<String> getAwsRegions() {
            if (this.awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsRegions;
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
        }

        public final Collection<String> getNonAwsRegions() {
            if (this.nonAwsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonAwsRegions;
        }

        @Override
        public final Builder nonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonAwsRegions(String ... nonAwsRegions) {
            this.nonAwsRegions(Arrays.asList(nonAwsRegions));
            return this;
        }

        public final void setNonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
        }

        public final Collection<String> getPillarPriorities() {
            if (this.pillarPriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pillarPriorities;
        }

        @Override
        public final Builder pillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarPriorities(String ... pillarPriorities) {
            this.pillarPriorities(Arrays.asList(pillarPriorities));
            return this;
        }

        public final void setPillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
        }

        public final String getArchitecturalDesign() {
            return this.architecturalDesign;
        }

        @Override
        public final Builder architecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
            return this;
        }

        public final void setArchitecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
        }

        public final String getReviewOwner() {
            return this.reviewOwner;
        }

        @Override
        public final Builder reviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
            return this;
        }

        public final void setReviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
        }

        public final Boolean getIsReviewOwnerUpdateAcknowledged() {
            return this.isReviewOwnerUpdateAcknowledged;
        }

        @Override
        public final Builder isReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
            return this;
        }

        public final void setIsReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
        }

        public final String getIndustryType() {
            return this.industryType;
        }

        @Override
        public final Builder industryType(String industryType) {
            this.industryType = industryType;
            return this;
        }

        public final void setIndustryType(String industryType) {
            this.industryType = industryType;
        }

        public final String getIndustry() {
            return this.industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        public final String getNotes() {
            return this.notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public final String getImprovementStatus() {
            return this.improvementStatus;
        }

        @Override
        public final Builder improvementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
            return this;
        }

        @Override
        public final Builder improvementStatus(WorkloadImprovementStatus improvementStatus) {
            this.improvementStatus(improvementStatus == null ? null : improvementStatus.toString());
            return this;
        }

        public final void setImprovementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkloadRequest build() {
            return new UpdateWorkloadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkloadRequest> {
        public Builder workloadId(String var1);

        public Builder workloadName(String var1);

        public Builder description(String var1);

        public Builder environment(String var1);

        public Builder environment(WorkloadEnvironment var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);

        public Builder nonAwsRegions(Collection<String> var1);

        public Builder nonAwsRegions(String ... var1);

        public Builder pillarPriorities(Collection<String> var1);

        public Builder pillarPriorities(String ... var1);

        public Builder architecturalDesign(String var1);

        public Builder reviewOwner(String var1);

        public Builder isReviewOwnerUpdateAcknowledged(Boolean var1);

        public Builder industryType(String var1);

        public Builder industry(String var1);

        public Builder notes(String var1);

        public Builder improvementStatus(String var1);

        public Builder improvementStatus(WorkloadImprovementStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

