/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NotificationType {
    LENS_VERSION_UPGRADED("LENS_VERSION_UPGRADED"),
    LENS_VERSION_DEPRECATED("LENS_VERSION_DEPRECATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NotificationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NotificationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationType> knownValues() {
        return Stream.of(NotificationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

